<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001, 2002 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays the actual .GIF/.PNG/.TIFF image
 *          of the chart
 *
 * Input GET/POST variables
 *   - width: chart width
 *   - height: chart width
 *   - pmargin0-3: plot margins
 *   - title: chart title
 *   - xaxis_label: x-axis label
 *   - yaxis_label: y-axis label
 *   - xdata[][]: data and label array for the y-axis
 *   - yaxis_scale: (boolean) 0: linear; 1: logarithmic
 *   - rotate_xaxis_lbl: (boolean) rotate X-axis labels 90 degrees
 *   - style: [bar|line] chooses the style of the chart
 */

  include ("acid_conf.php");
  include ("acid_state_common.inc");
  include ("acid_graph_common.php");

  session_start();

  $xdata = $HTTP_SESSION_VARS['xdata'];
  $width = ImportHTTPVar("width");
  $height = ImportHTTPVar("height");
  $pmargin0 = ImportHTTPVar("pmargin0");
  $pmargin1 = ImportHTTPVar("pmargin1");
  $pmargin2 = ImportHTTPVar("pmargin2");
  $pmargin3 = ImportHTTPVar("pmargin3");
  $title = ImportHTTPVar("title");
  $xaxis_label = ImportHTTPVar("xaxis_label");
  $yaxis_label = ImportHTTPVar("yaxis_label");
  $yaxis_scale = ImportHTTPVar("yaxis_scale");
  $xaxis_grid = ImportHTTPVar("xaxis_grid");
  $yaxis_grid = ImportHTTPVar("yaxis_grid");
  $rotate_xaxis_lbl = ImportHTTPVar("rotate_xaxis_lbl");
  $style = ImportHTTPVar("style");

  LoadGraphingLib($ChartLib_path);

  /* Create the data and label array */
  for ($i = 0; $i < count($xdata); $i++)
  {
      $xlabel[$i] = $xdata[$i][0];
      $ydata[$i] = $xdata[$i][1];
  }

  if ( $style == "pie" )
     $graph = new PieGraph($width, $height);
  else
     $graph = new Graph($width, $height);

  /* Set Margins */
  $graph->img->SetMargin($pmargin0,$pmargin1,$pmargin2,$pmargin3);    
  $graph->img->SetAntiAliasing();

  //$graph->SetShadow();

  /* Set Plot type */
  switch($style)
  {
     case "bar":
        $plot[0] = new BarPlot($ydata);
        break;
     case "pie":
        $plot[0] = new PiePlot3D($ydata);
        break;
     case "line":
        $plot[0] = new LinePlot($ydata);
        break;
  }

  //$plot[0]->SetColor("#000000");

  if ( ($style == "bar") || ($style == "line") )
  {
     /* Set Scale */
     if ( $yaxis_scale == 1 )
        $graph->SetScale("textlog");
     else
        $graph->SetScale("textlin");

     $plot[0]->SetFillColor("#BE0505");
     //$plot[0]->SetFillColor($GLOBALS['chart_bar_color_default']);

     /* Set Gridlines */
     if ( $xaxis_grid == 1 )
        $graph->xgrid->Show(true);
     else
        $graph->xgrid->Show(false);

     if ( $yaxis_grid == 1 )
        $graph->ygrid->Show(true);
     else
        $graph->ygrid->Show(false);
  
     /* Set Axis Labels */
     $graph->xaxis->title->Set($xaxis_label);
     $graph->yaxis->title->Set($yaxis_label);

     //$graph->xaxis->SetFont(FF_ARIAL,FS_NORMAL,11);

     $graph->xaxis->SetTickLabels($xlabel);

     if ( $rotate_xaxis_lbl == 1 )
        $graph->xaxis->SetLabelAngle(90);
  }

  if ( $style == "pie" )
  {
     $plot[0]->SetLegends($xlabel);
  }

  //$plot[0]->ShowValue(true);
  //$plot[0]->SetShadow();

  /* Set Title */
  //$graph->title->SetFont(FF_COMIC,FS_NORMAL,18);
  $graph->title->Set($title);


  $graph->Add($plot[0]);

  $graph->Stroke();
?>









