/*
 * This file is part of John the Ripper password cracker,
 * Copyright (c) 1996-98 by Solar Designer
 */

/*
 * Bitslice DES encryption.
 */

#include "arch.h"
#include "DES_bs.h"

/* Include the S-boxes here, so that the compiler can inline them */
#include "DES_bs_s.c"

#define b				DES_bs_all.B
#define e				DES_bs_all.E

void DES_bs_body()
{
	ARCH_WORD **k = DES_bs_all.Kp;
	int count = 8;

	do {
		s1(*e[0] ^ *k[0], *e[1] ^ *k[1], *e[2] ^ *k[2],
			*e[3] ^ *k[3], *e[4] ^ *k[4], *e[5] ^ *k[5],
			&b[40], &b[48], &b[54], &b[62]);
		s2(*e[6] ^ *k[6], *e[7] ^ *k[7], *e[8] ^ *k[8],
			*e[9] ^ *k[9], *e[10] ^ *k[10], *e[11] ^ *k[11],
			&b[44], &b[59], &b[33], &b[49]);
		s3(*e[12] ^ *k[12], *e[13] ^ *k[13], *e[14] ^ *k[14],
			*e[15] ^ *k[15], *e[16] ^ *k[16], *e[17] ^ *k[17],
			&b[55], &b[47], &b[61], &b[37]);
		s4(*e[18] ^ *k[18], *e[19] ^ *k[19], *e[20] ^ *k[20],
			*e[21] ^ *k[21], *e[22] ^ *k[22], *e[23] ^ *k[23],
			&b[57], &b[51], &b[41], &b[32]);
		s5(*e[24] ^ *k[24], *e[25] ^ *k[25], *e[26] ^ *k[26],
			*e[27] ^ *k[27], *e[28] ^ *k[28], *e[29] ^ *k[29],
			&b[39], &b[45], &b[56], &b[34]);
		s6(*e[30] ^ *k[30], *e[31] ^ *k[31], *e[32] ^ *k[32],
			*e[33] ^ *k[33], *e[34] ^ *k[34], *e[35] ^ *k[35],
			&b[35], &b[60], &b[42], &b[50]);
		s7(*e[36] ^ *k[36], *e[37] ^ *k[37], *e[38] ^ *k[38],
			*e[39] ^ *k[39], *e[40] ^ *k[40], *e[41] ^ *k[41],
			&b[63], &b[43], &b[53], &b[38]);
		s8(*e[42] ^ *k[42], *e[43] ^ *k[43], *e[44] ^ *k[44],
			*e[45] ^ *k[45], *e[46] ^ *k[46], *e[47] ^ *k[47],
			&b[36], &b[58], &b[46], &b[52]);

		s1(*e[48] ^ *k[48], *e[49] ^ *k[49], *e[50] ^ *k[50],
			*e[51] ^ *k[51], *e[52] ^ *k[52], *e[53] ^ *k[53],
			&b[8], &b[16], &b[22], &b[30]);
		s2(*e[54] ^ *k[54], *e[55] ^ *k[55], *e[56] ^ *k[56],
			*e[57] ^ *k[57], *e[58] ^ *k[58], *e[59] ^ *k[59],
			&b[12], &b[27], &b[1], &b[17]);
		s3(*e[60] ^ *k[60], *e[61] ^ *k[61], *e[62] ^ *k[62],
			*e[63] ^ *k[63], *e[64] ^ *k[64], *e[65] ^ *k[65],
			&b[23], &b[15], &b[29], &b[5]);
		s4(*e[66] ^ *k[66], *e[67] ^ *k[67], *e[68] ^ *k[68],
			*e[69] ^ *k[69], *e[70] ^ *k[70], *e[71] ^ *k[71],
			&b[25], &b[19], &b[9], &b[0]);
		s5(*e[72] ^ *k[72], *e[73] ^ *k[73], *e[74] ^ *k[74],
			*e[75] ^ *k[75], *e[76] ^ *k[76], *e[77] ^ *k[77],
			&b[7], &b[13], &b[24], &b[2]);
		s6(*e[78] ^ *k[78], *e[79] ^ *k[79], *e[80] ^ *k[80],
			*e[81] ^ *k[81], *e[82] ^ *k[82], *e[83] ^ *k[83],
			&b[3], &b[28], &b[10], &b[18]);
		s7(*e[84] ^ *k[84], *e[85] ^ *k[85], *e[86] ^ *k[86],
			*e[87] ^ *k[87], *e[88] ^ *k[88], *e[89] ^ *k[89],
			&b[31], &b[11], &b[21], &b[6]);
		s8(*e[90] ^ *k[90], *e[91] ^ *k[91], *e[92] ^ *k[92],
			*e[93] ^ *k[93], *e[94] ^ *k[94], *e[95] ^ *k[95],
			&b[4], &b[26], &b[14], &b[20]);

		k += 96;
	} while (--count);
}
