// $Id: inline.h,v 1.3 2003/02/15 21:46:42 redmaze Exp $
#ifndef __INLINE_H__
#define __INLINE_H__

#ifdef GIDS

#ifndef IPFW
#include <libipq.h>
#include <linux/netfilter.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#include <sys/unistd.h>
#include <errno.h>
#endif /* IPFW */
#include "snort.h"
#include "decode.h"

typedef struct _inline_vals
{
    int drop;
    int reject;
    int replace;
    int proto;
} IV;

#ifndef IPFW
struct ipq_handle *ipqh;
#endif
IV iv;

int InitInline();
#ifndef IPFW
void IpqLoop();
#else
void IpfwLoop();
#endif /* IPFW */
int InlineDrop();  /* call to drop current packet */
int InlineReject(Packet *); /* call to reject current packet */
int InlineAccept();
int InlineReplace();
int InlineMode();

#else
#define InlineMode(a)	(0)
#endif /* GIDS */


#endif /* __INLINE_H__ */
