% Network Management and Monitoring
% Cacti command line tools


# Introduction

## Goals


In this exercise you will learn some command-line scripts for adding
devices, which can be used for scripting.

## Notes

* Commands preceded with `$` imply that you should execute the command as
  a general user - not as root.
* Commands preceded with `#` imply that you should be working as root.
* Commands with more specific command lines (e.g. `rtrX>` or `mysql>`) 
  imply that you are executing commands on remote equipment, or within 
  another program.

# Exercises

As you have noticed, adding devices to Cacti via the user interface can take
quite some time, as for each device you will have:

- add the device, filling out the description, hostname, SNMP community
- pick the interfaces or resources to be monitored (graphed)
- create the graph tree enty
- add the graphs to the graph tree.

There are plugins to automate this, such as the aptly named "autom8":
<http://docs.cacti.net/plugin:autom8>

But if you wanted to add many devices in one pass, you would want to use
something more efficient.

Luckily, Cacti has command line tools for this:

<http://www.cacti.net/downloads/docs/html/scripts.html>

The commands provided are:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
add_data_query.php
add_device.php
add_graphs.php
add_graph_template.php
add_perms.php
add_tree.php
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

On Ubuntu, these are located under `/usr/share/cacti/cli`

The three commands we'll be focusing on are:

* add_device.php
* add_graphs.php
* add_tree.php

They are individually documented here:

* <http://www.cacti.net/downloads/docs/html/cli_add_device.html>
* <http://www.cacti.net/downloads/docs/html/cli_add_graphs.html>
* <http://www.cacti.net/downloads/docs/html/cli_add_tree.html>

The way it works, is that we will use the three commands in sequence, to:

- Add a device
- Create graphs for the device we've added
- Add these graphs to a tree

Below is a walkthrough of adding a device and some graphs using these commands.
Read through, and proceed to the exercise at the end.


# 1. Adding a device

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ cd /usr/share/cacti/cli
$ sudo ./add_device.php | less
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You will see a lot of help output. You can page through it to look at all
the options. So we know what we will put for:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--description   => the description of the host, say "backbone router" or
                   "rtrX.ws.nsrc.org" - but that is up to you to decide
--ip            => the ip or hostname - we recommend hostname! - of the device

--version       => SNMP version (2)
--comunity      => the SNMP community. By default, Cacti will try 'public',
                   although you can pre-configure other communities in the
                   Cacti user interface
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

We're missing two pieces of information:

* What availability method (PING or SNMP) to check if the device is "up"?
  From the options listed in the output of the command, we can see:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--avail        pingsnmp, [ping][none, snmp, pingsnmp]
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

We will use the "snmp" availability test.
  
* The Template: is it a Cisco, a Linux host, a generic SNMP device?

    For this, we use the `--list-host-templates` command, which will tell us
    which type of device Template is supported:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_device.php  --list-host-templates

Valid Host Templates: (id, name)
0   None
1   Generic SNMP-enabled Host
3   ucd/net SNMP Host
4   Karlnet Wireless Bridge
5   Cisco Router
6   Netware 4/5 Server
7   Windows 2000/XP Host
8   Local Linux Machine
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


From the above, we can see that Cisco Router is template id number 5.

Let's build our command line. If we are in group 7, we'd want to add, for
example, router 7, which has IP address 10.0.7.254 and 10.10.0.227. Let's
use IP 10.10.7.254 - if you have already created this device in Cacti,
you may want to pick another device.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_device.php --description="rtr7.ws.nsrc.org" --ip=10.10.7.254 \
  --template=5 --avail=snmp --version=2 --community=NetManage 
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You should see output similar to this:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Adding rtr7.ws.nsrc.org (10.10.7.254) as "Cisco Router" using SNMP v2 with
  community "NetManage" 
Success - new device-id: (2)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Note the device-id "2". This is Cacti's internal reference for this device.
You don't need to write it down.

Now, verify in the Web UI that the device has indeed been added:

    Console -> Management -> Devices


# 2. Adding graphs

This is the most complicated part of the operation, but once you understand
the steps involved, it will be easier to repeat for other hosts.

First, let's run the add_graphs.php commands without any options to see what
it expects from us:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php | less
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Notice the options `--host-id`, `--graph-type`, `--graph-template-id`.

We already know the host-id from the previous section - if you don't remember
it, don't worry, we'll get to it below.

Graph type (`--graph-type`) is is either cg or ds. 'cg' is used for absolute
values such as gauge readings (CPU temperature, fan speed, ...), while 'ds'
is used for interface counters etc. (Data Sources). We are using 'ds' type
graphs for interfaces (`--graph-type=ds`)

Also pay attention in particular to the "List Options" section, as we will be
using this quite a bit to find out what SNMP data we want to query:

List Options:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--list-hosts
--list-graph-templates [--host-template-id=[ID]]
--list-input-fields --graph-template-id=[ID]
--list-snmp-queries
--list-query-types  --snmp-query-id [ID]
--list-snmp-fields  --host-id=[ID] [--snmp-query-id=[ID]]
--list-snmp-values  --host-id=[ID] [--snmp-query-id=[ID]] --snmp-field=[Field]
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


A very useful command is the `--list-hosts` options, that we'll use to see
which hosts are available, as we'll also need to get the host-id.

Let's use this to fetch the host-id for the host you added in the previous
section:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php --list-hosts
    
Known Hosts: (id, hostname, template, description)
1   127.0.0.1   8   Localhost
2   10.10.7.254 5   rtr7.ws.nsrc.org
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


In this case, the host-id of rtr7 is '2'.

Is this enough to build our command?  Not yet. We still need to specify the
following:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
"graph template id" (--graph-template-id)
"snmp query id" (--snmp-query-id)
"snmp field" (--snmp-field)
"snmp value" (--snmp-value)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

## Find the graph template id

To find out which graph templates are available, use the `--list-graph-templates`
option:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php --list-graph-templates
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

In the output, there are several options we could be interested in:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        2   Interface - Traffic (bits/sec)
        18  Cisco - CPU Usage
        22  Interface - Errors/Discards
        23  Interface - Unicast Packets
        24  Interface - Non-Unicast Packets
        25  Interface - Traffic (bytes/sec)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

We're really interested in creating bits/sec graphs at this point, so that's
graph template no. 2

## Find out what types of SNMP queries are possible:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php --list-snmp-queries

Known SNMP Queries:(id, name)
1   SNMP - Interface Statistics
2   ucd/net -  Get Monitored Partitions
3   Karlnet - Wireless Bridge Statistics
4   Netware - Get Available Volumes
6   Unix - Get Mounted Partitions
7   Netware - Get Processor Information
8   SNMP - Get Mounted Partitions
9   SNMP - Get Processor Information
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Here, we are interested in the SNMP Interface statistics, therefore,
`--snmp-query-id=1` is what we are looking for.

## Find the valid SNMP query type

Ok, but what kind of data do we want to graph? Find out using the
query types possible for snmp-query-type 1 (SNMP - Interface Statistics):

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php --snmp-query-id=1 --list-query-types

Known SNMP Query Types: (id, name)
2   In/Out Errors/Discarded Packets
3   In/Out Non-Unicast Packets
4   In/Out Unicast Packets
9   In/Out Bytes (64-bit Counters)
13  In/Out Bits
14  In/Out Bits (64-bit Counters)
16  In/Out Bytes
20  In/Out Bits with 95th Percentile
21  In/Out Bits with Total Bandwidth
22  In/Out Bytes with Total Bandwidth
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Let's graph Ib/Out Bits (64-bit Counters) - that is #14. This is
option `--snmp-query-type-id`

## Find which interfaces to graph on this host

We need to tell Cacti *which* interfaces we will be creating
graphs for on our device, using the two options of the add_graphs.php
command `--snmp-field` and `--snmp-value`


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php --host-id=2 --list-snmp-fields

Known SNMP Fields for host-id 2: (name)
ifAlias
ifDescr
ifHighSpeed
ifHwAddr
ifIndex
ifIP
ifName
ifOperStatus
ifSpeed
ifType
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


We're only really interested in interfaces of type ethernet, therefore we'll
use the "ifType" SNMP field to narrow down our search.

To find out how to specify the "ethernet" type...:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php --host-id=2 --snmp-field=ifType --list-snmp-values
        
Known values for ifType for host 3: (name)
ethernetCsmacd(6)
other(1)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        
ethernet is 'ethernetCsmacd(6)'

Wow!

The final command:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php --host-id=2 --snmp-query-id=1 --snmp-query-type-id=14 \
  --snmp-field=ifType --snmp-value='ethernetCsmacd(6)' --graph-template-id=2 \
  --graph-type=ds
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You should see something similar to this:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Graph Added - graph-id: (5) - data-source-ids: (8, 8)
    Graph Added - graph-id: (6) - data-source-ids: (9, 9)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

... why two graphs? One for each interface if this is your Cisco router.

Check in the Web UI that the graphs have been create (Devices -> select
your host -> Graph List)

## NOTE: 
We could have picked another criteria to decide which interfaces
to graph. For example "Only graph interfaces that are 'up'". To find out
how, look at the examples at the end of this lab.

# 3. Add graph items to the tree

The last step is to add these graphs to the Graph Tree.

Check the possible options for this command:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_tree.php | less
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Note the following options:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--type=[tree|node]
--node-type=[header|host|graph]
--tree-id=[ID]
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

First, let's use the add_tree.php command to see if we have any trees created
in our Cacti installation:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_tree.php --list-trees

Known Trees:
id  sort method         name
1   Manual Ordering (No Sorting)    Default Tree
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

In the above example, we have one tree: Default.

If you need to create a new tree, save some typing and create it directly in
the Web UI, then run the `--list-trees` command again:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_tree.php --list-trees

Known Trees:
id  sort method         name
1   Manual Ordering (No Sorting)    Default Tree
2   Manual Ordering (No Sorting)    NETMGMT routers
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Note: We could have created the tree using add_tree.php. (How?)

Let's add all graphs for our device id 2 from earlier - we know that
the device id is 2, the tree id is 2, we want to add a Graph node (not
a subtree), and we want all graphs for the device (type = node), not
just a single graph from that device.

The final command:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_tree.php --host-id=2 --tree-id=2 --node-type=host --type=node
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Added Node node-id: (8)

Done! Check with the Web UI that the Graphs for the device have been placed
in the tree.

## Additional commands

If you want to add interfaces that are 'Up' instead of just interfaces that
are "ethernet", replace "ifType" with "ifOperStatus" for `--snmp-field`, and
replace `--snmp-value='ethernetCsmacd(6)'` with `--snmp-value=Up`

Example to add all OperUp interfaces:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
./add_graphs.php --host-id=7 --graph-type=ds --graph-template-id=2 \
    --snmp-query-id=1 --snmp-query-type-id=14 --snmp-field=ifOperStatus \
    --snmp-value=Up
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


# Summary and more sample commands
--------------------------------

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo ./add_graphs.php --list-hosts
# choose your host ID from the list

$ sudo ./add_graphs.php --list-graph-templates
# 2 = Interface - Traffic (bits/sec)

$ sudo ./add_graphs.php --list-snmp-queries
# 1 = SNMP - Interface Statistics

$ sudo ./add_graphs.php --list-query-types --snmp-query-id=1
# 14 = In/Out Bits (64-bit Counters)

$ sudo ./add_graphs.php --list-snmp-fields --host-id=2 --snmp-query-id=1
# list includes ifType

### Add all ifs of type ethernetCsmaCd (type 6) ###
$ sudo ./add_graphs.php --list-snmp-values --host-id=2 --snmp-query-id=1 \
  --snmp-field=ifType
# Known values for ifType for host 2: (name)
# ethernetCsmacd(6)
# other(1)

$ sudo ./add_graphs.php --host-id=2 --graph-type=ds --graph-template-id=2 \
  --snmp-query-id=1 --snmp-query-type-id=14 --snmp-field=ifType \
  --snmp-value='ethernetCsmacd(6)'

or:

### Add all OperUp ifs: ###
$ sudo ./add_graphs.php --list-snmp-values --host-id=2 --snmp-query-id=1 \
  --snmp-field=ifOperStatus
# Known values for ifOperStatus for host 2: (name)
# Down
# Up

$ sudo ./add_graphs.php --host-id=2 --graph-type=ds --graph-template-id=2 \
  --snmp-query-id=1 --snmp-query-type-id=14 --snmp-field=ifOperStatus \
  --snmp-value=Up
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
