# Cisco Config Elements

# Introduction

## Goals

* Learn the basic set of IOS commands required to enable SSH on your Cisco
  Switch or Router
  
## Notes

* Commands preceded with "$" imply that you should execute the command as
  a general user - not as root.
* Commands preceded with "#" imply that you should be working as root.
* Commands with more specific command lines (e.g. "rtrX>" or "mysql>") 
  imply that you are executing commands on remote equipment, or within 
  another program.
* If a command line ends with "\" this indicates that the command continues
  on the next line and you should treat this as a single line.

# Exercises Part I

## Work as a group

Each group has 4 network devices:

 * core1.campusY.ws.nsrc.org
 * bdr1.campusY.ws.nsrc.org
 * dist1-b1.campusY.ws.nsrc.org
 * dist1-b2.campusY.ws.nsrc.org
 
 Each of these devices has the user _nmmlab_ configured with both a log in password and 
 and enable password. At this time telnet is enabled on these devices and ssh is not 
 yet configured.
 
 As a group you need to update all four of these devices so that when you finish this 
 lab you can log in as the _nmmlab_ only using ssh and with the password given in class.

## Connect to your router or switch

First, log in to your virtual machine (srvX.campusY.ws.nsrc.org).

Next, connect to the network device on which you will be working:

~~~
$ telnet <DEVICE-NAME>.campusY.ws.nsrc.org
~~~

	username: nmmlab
	password: <GIVEN IN CLASS>

Display information about your network device

~~~
<device-name>.campusy> enable				
Password:						(password given in class)
<device-name>.campusy# show run				(space to continue)
<device-name>.campusy# show int FastEthernet0/0		(or any other interface that is up)
<device-name>.campusy# show ?				(lists all options)
~~~

## Configure your router or switch to only use SSH

These steps will do the following:

* Create an ssh key for your router
* Create an encrypted password for the user nmmlab
* Encrypt the enable password
* Turn off telnet (unencrypted) access to your router
* Turn on SSH (version 2) access to your router

You should be connected to your router or switch and at the enable prompt. The prompt
will look something like:

~~~
<device-name>.campusy#
~~~

At this prompt do the following:

~~~
<device-name>.campusy# configure terminal					(conf t)
<device-name>.campusy(config)# aaa new-model
<device-name>.campusy(config)# ip domain-name ws.nsrc.org
<device-name>.campusy(config)# crypto key generate rsa

	How many bits in the modulus [512]: 2048
~~~
	
Wait for the key to generate. You can now specify passwords and they will be 
encrypted. First let's remove our nmmlab user temporarily, then we'll recreate 
the user.

**CRITICAL! CRITICAL! CRITICAL!**

PLEASE DO NOT USE ANYTHING OTHER THAN THE CLASS PASSWORD AND THE USER "nmmlab"

If you use other usernames or passwords you will break exercises for other participants 
of the class during the week. Thank you!

~~~
<device-name>.campusy(config)# no username nmmlab
<device-name>.campusy(config)# username nmmlab secret 0 <CLASS PASSWORD>
~~~

The nmmlab user's password (of <CLASS PASSWORD>) is encrypted. Next let's encrypt 
the enable password as well:

~~~
<device-name>.campusy(config)# enable secret 0 <CLASS ENABLE PASSWORD>
~~~

Now we'll tell our router to only allow SSH connections on the 5 defined 
consoles (vty 0 through 4):

~~~
<device-name>.campusy(config)# line vty 0 4
<device-name>.campusy(config-line)# transport input ssh
<device-name>.campusy(config-line)# exit
~~~

This drops us out of the "line" configuration mode and back in to the general 
configuration mode. Now we'll tell the router to log SSH-related events and to 
only allow SSH version 2 connections:

~~~
<device-name>.campusy(config)# ip ssh logging events
<device-name>.campusy(config)# ip ssh version 2
~~~

Now exit from configuration mode:

~~~
<device-name>.campusy(config)# exit
~~~

And, write these changes to the routers permament configuration:

~~~
<device-name>.campusy# write memory				(wr mem)
~~~

Ok. That's it. You can no longer use telnet to connect to your
router.  You must connect using SSH with the user _nmmlab_ and
password <CLASS PASSWORD>.  The enable password is, <CLASS ENABLE PASSWORD>

Naturally in a real-world situation you would use much more secure passwords.

Before you exit your Telnet session be sure to test ssh connectivity
from another PC in your group (or, open another terminal window).
Do this in case you made a mistake to avoid locking yourself out
of your router.

First, try connection again with telnet from your virtual machine:

~~~
$ telnet <DEVICE-NAME>.campusY.ws.nsrc.org
~~~

What happens? You should see something like:

~~~
Trying 172.26.10.2...  (for example only)
telnet: Unable to connect to remote host: Connection refused
~~~

Now try connecting with SSH:

~~~
$ ssh nmmlab@<DEVICE-NAME>.campusY.ws.nsrc.org
~~~

You should see something looks similar to this:

~~~
The authenticity of host ' bdr1.campus6.ws.nsrc.org (100.68.6.1)' can't be 	
established. RSA key fingerprint is 93:4c:eb:ad:5c:4a:a6:3e:8b:9e:
4f:e4:e2:eb:e4:7f. Are you sure you want to continue connecting 
(yes/no)? 
~~~

Enter in "yes" and press ENTER to continue...

Now you'll see the follwoing:

~~~
Password: <CLASSS PASSWORD>
<device-name>.campusY>
~~~

(If you receive an error while trying to connect see the _Troubleshooting_ Section below)

Type "enable" to allow us to execute privileged commands:
	
~~~
<device-name>.campusY> enable
Password: <CLASS ENABLE PASSWORD>
<device-name>.campusy#
~~~

Now let's view the current router configuration:

~~~
<device-name>.campusy# show running					(sh run)
~~~

Press the space bar to continue. Note some of the entries like:

~~~
enable secret 5 $1$wGtR$bKZqFAPXYjmV6OrLCC3hP.
.
.
.
username nmmlab secret 5 $1$DQAd$qB0su4clCXPaSE7miLVcB0
.
.  			(lots of lines down)
.
line vty 0 4
 exec-timeout 0 0
 transport preferred none
 transport input ssh
~~~

You can see that both the enable password and the password for the user _nmmlab_ 
have been encrypted. This is a good thing.

Now you should exit the router interface to complete this exercise:

~~~
<device-name>.campusy# exit
~~~
	
And, if you still have your older Telnet session in another window running 
be sure to exit from that as well.

# Troubleshooting

If you attempted to log in and received a message like this:

"Unable to negotiate with 172.26.10.2 port 22: no matching key exchange method found. 
Their offer: diffie-hellman-group1-sha1"

The version of software on your network device is using older, weaker encryption ciphers. 
In order to support this there are a couple of options we can consider:

1. You can override ssh refusing to connect to older, vulnerable encrption key exchange 
algorithm by running the ssh comand like this
   
~~~
$ ssh -oKexAlgorithms=+diffie-hellman-group1-sha1 nmmlab@<device-name>.campusY.ws.nsrc.org
~~~

...but that is painful. Let's update your virtual machine's ssh client configuration to allow for this 
older key exchange. We'll do this by updating your machine's system-wide ssh-client configuration file. 
Follow these steps:
 
~~~
$ sudo editor /etc/ssh/ssh_config
~~~

At the very end of the file add the following line:

~~~
KexAlgorithms +diffie-hellman-group1-sha1
~~~

Save the file and exit.

Now try connecting to your network device again:

~~~
$ ssh nmmlab@<DEVICE-NAME>.campusY.ws.nsrc.org
~~~

And you should be able to log in.


# NOTES

1. If you are locked out of your router or switch after this exercise let your
    instructor know and they can reset your network device's configuration back to its
    original state.
2. Please only do this exercise once. If multiple people do this exercise 
    it's very likely that access to the router or switch will be broken.
3. During the week you will configure items such as SNMP, Netflow and more on
    your local network devices. From now on you can simply connect to the device 
    directly from your laptop or desktop machine using SSH.


# Exercises - Part 2: NTP Configuration

## Configure NTP and Timezone

Perhaps you can select another person in your group to execute the following steps to allow them to 
practice. 

Your first step is to connect to your router:

~~~
$ ssh nmmlab@<DEVICE-NAME>.campusY.ws.nsrc.org
~~~

Now we will enable the Network Time Protocol so that we can synchronize your router's time with your 
PCs time so that all devices on our local network will have the same time. To do this follow these 
steps:

~~~
<device-name>.campusY> enable                      (en)
Password:
<device-name>.campusY# configure terminal          (conf t)
<device-name>.campusY(config)# ip name-server 100.68.100.254
<device-name>.campusY(config)# ip domain-lookup
<device-name>.campusY(config)# ntp server pool.ntp.org
~~~

At this point you may see something like this:

~~~
bdr1.campus6(config)#ntp server pool.ntp.org
Translating "pool.ntp.org"...domain server (100.68.100.254)

Translating "pool.ntp.org"...domain server (100.68.100.254)
~~~

Wait a few moments for this to complete and then you can continue.

~~~
<device-name>.campusY(config)# no clock timezone
<device-name>.campusY(config)# exit
<device-name>.campusY# write memory                 (wr mem)
~~~

This uses the NTP time servers run by ntp.org and should end up selecting machines that are 
geographically near to you. This, also, indicates that you wish to use UTC time (same as 
GMT time) for this router.

To verify NTP status, NTP server associations and the reported time on your router:

~~~
<device-name>.campusY# show ntp status             (sh ntp stat)
~~~

After some time you will see something like (you may see "unsynchronized" for a while):

~~~
 dist1-b1.campus6#show ntp status
 Clock is synchronized, stratum 2, reference is 129.6.15.28
 nominal freq is 250.0000 Hz, actual freq is 250.0000 Hz, precision is 2**18
 reference time is DC50A690.1078EC4D (22:30:40.064 UTC Thu Feb 16 2017)
 clock offset is 28.1831 msec, root delay is 212.07 msec
 root dispersion is 199.16 msec, peer dispersion is 170.97 msec
~~~

... and to see the NTP server associations:

~~~
<device-name>.campusY# show ntp associations   (sh ntp assoc)
~~~

~~~
      address         ref clock     st  when  poll reach  delay  offset    disp
+~104.131.53.252   209.51.161.238    2    48    64  377   140.0  -32.41    28.2
*~129.6.15.28      .ACTS.            1   109    64  324   212.1   28.18   142.5
 * master (synced), # master (unsynced), + selected, - candidate, ~ configured
~~~
 
... and, finally, to see your router's current time:
 
~~~
rtrN# show clock                   (sh clo)
~~~

You should see something like: 
 
   22:32:42.996 UTC Thu Feb 16 2017
 
Now you can exit from your router:
 
~~~
 <device-name>.campusY# exit
~~~

Make sure your team finishes working on the other devices in your group. If anyone has problems 
connecting to a device see the _Troubleshooting_ section above.

