---
title: LibreNMS
author: Campus Network Design Workshop
---

Installing LibreNMS - tuning
============================

Goals
-----

-   Make LibreNMS perform better by tuning MySQL and installing rrdcached

Notes
-----

-   Commands preceded with "\$" imply that you should execute the command as a
    general user - not as root.

-   Commands preceded with "\#" imply that you should be working as root.

-   Commands with more specific command lines (e.g. "rtrX\>" or "mysql\>") imply
    that you are executing commands on remote equipment, or within another
    program.

-   These instructions assume you are the root user. If you are not, prepend
    ''sudo'' to the shell commands (the ones that aren't at ''mysql\>'' prompts)
    or temporarily invoke root privileges with ''sudo -s''.

 

Install rrdcache support for LibreNMS
-------------------------------------

rrdcache allows LibreNMS to write information about devices to memory instead of
directly to disk. LibreNMS is a resource-intensive tool and adding memory cache
support to LibreNMS will lessen the load on your server.

To do this first become root if your not already the root user:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo bash
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Then install the rrdcached caching package:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# apt-get install rrdcached
# editor /etc/default/rrdcached
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

And change the file so that it looks like this:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# /etc/default file for RRD cache daemon

# Full path to daemon
DAEMON=/usr/bin/rrdcached

# Optional override flush interval, in seconds.
WRITE_TIMEOUT=1800

# Optional override maximum write delay, in seconds.
WRITE_JITTER=1800

# Optional override number of write_threads
WRITE_THREADS=4

# Where database files are placed.  If left unset, the default /tmp will
# be used.  NB: The daemon will reject a directory that has symlinks as
# components.  NB: You may want to have -B in BASE_OPTS.
BASE_PATH=/opt/librenms/rrd/

# Where journal files are placed.  If left unset, journaling will
# be disabled.
JOURNAL_PATH=/var/tmp/

# FHS standard placement for process ID file.
PIDFILE=/var/run/rrdcached.pid

# FHS standard placement for local control socket.
SOCKFILE=/var/run/rrdcached.sock

# Optional override group that should own/access the local control
# socket
SOCKGROUP=librenms

# Optional override access mode of local control socket.
#SOCKMODE=0660

# Optional unprivileged group to run under when daemon.  If unset
# retains invocation group privileges.
DAEMON_GROUP=librenms

# Optional unprivileged user to run under when daemon.  If unset
# retains invocation user privileges.
DAEMON_USER=librenms

# Any other options not specifically supported by the script (-P, -f,
# -F, -B).
BASE_OPTIONS="-F -B"
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Save the file and exit and then:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# systemctl restart rrdcached
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Next edit the file ''/opt/librenms/config.php'' and change one line and add
another:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# cd /opt/librenms
# editor config.php
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Find the line:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#$config['rrdcached']    = "unix:/var/run/rrdcached.sock";
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

And change it to:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$config['rrdcached']    = "unix:/var/run/rrdcached.sock";
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Find the line:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$config['rrdtool_version'] = ;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

and be sure it matched the version of rrdtool you are using. In our case 1.5.5, or:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$config['rrdtool_version'] = '1.5.5';
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Now we can restart the Apache web server to pick up all the various changes we
have made.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# systemctl restart apache2
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 

Fine tuning MySQL
-----------------

There are a few MySQL server settings we want to add to optimize how LibreNMS uses the
MySQL database server back end.

First, go to the correct MySQL configuration directory:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# /etc/mysql/conf.d
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

We will create the file librenms.cnf and add in a few statements:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# edtor librenms.cnf
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

In this file add the following lines:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
[mysqld]

# From installation instructions
# http://docs.librenms.org/Installation/Installation-Ubuntu-1604-Apache/

innodb_file_per_table=1

# Required to prevent corruption of database with mysql 5.7+
# https://github.com/librenms/librenms/issues/3647
# https://git.nsrc.org/nsrc/netmgmt/issues/3

sql-mode=""

# Required for decent performance
# http://docs.librenms.org/Support/Performance/
# http://dev.mysql.com/doc/refman/5.7/en/innodb-parameters.html#sysvar_innodb_flush_log_at_trx_commit
innodb_flush_log_at_trx_commit=0
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Now save the file and restart the MySQL server:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# systemctl restart mysql
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If you are interested in the details about this change you can read about it at
http://dev.mysql.com/doc/refman/5.7/en/innodb-multiple-tablespaces.html

=\> YOU CAN NOW PROCEED TO THE BASIC CONFIGURATION LAB! \<=
