---
title: LibreNMS
author: Campus Network Design Workshop
---

Installing LibreNMS (HowTo)
===========================

Version
-------

-   HowTo Document for Installing LibreNMS from source on Ubuntu Server 16.04 LTS

Goals
-----

-   Learn how to initially install the LibreNMS Network Management System

Notes
-----

-   Commands preceded with "\$" imply that you should execute the command as a
    general user - not as root.

-   Commands preceded with "\#" imply that you should be working as root.

-   Commands with more specific command lines (e.g. "rtrX\>" or "mysql\>") imply
    that you are executing commands on remote equipment, or within another
    program.

-   These instructions assume you are the root user. If you are not, prepend
    ''sudo'' to the shell commands (the ones that aren't at ''mysql\>'' prompts)
    or temporarily invoke root privileges with ''sudo -s''.

 

Create database
---------------

NOTE: These instructions are based on the [official LibreNMS installation
notes](http://docs.librenms.org/Installation/Installation-(Debian-Ubuntu)/) and
have been tested on a fresh install of Ubuntu 14.04.

We will assume that the database is running on the same machine as your network
management server (this is the most common initial deployment scenario).

For this class we will install on db.campusY.ws.nsrc.org. Connect to this machine and 
become root:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo bash
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Then install mysql and configure:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# apt-get update
# apt-get install mysql-server mysql-client
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You will be asked to enter a password for the MySQL root user. *Be absolutely sure*
that you remember what you choose here. You will use this later.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# mysql -uroot -p
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Input the MySQL root password (the one you chose in the previous step) to enter 
the MySQL command-line interface where you will get a *mysql\>* prompt.

Create the database:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CREATE DATABASE librenms;
GRANT ALL PRIVILEGES ON librenms.*
TO 'librenms'@'localhost'
IDENTIFIED BY '<CLASS_PASSWORD>'
;
FLUSH PRIVILEGES;
exit
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**PLEASE NOTE**

Here we are using \<CLASS_PASSWORD\> as the password for LibreNMS to access MySQL. 
Please replace \<CLASS_PASSWORD\> with, you've guessed it, the class password :)


Install LibreNMS
----------------

The NMS is the host is where the web server and SNMP poller run.

Install the required software:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
apt-get install mysql-server mysql-client libapache2-mod-php php-cli php-mysql php-gd php-snmp php-pear php-curl snmp graphviz php-mcrypt php-json apache2 fping imagemagick whois mtr-tiny nmap python-mysqldb snmpd php-net-ipv4 php-net-ipv6 rrdtool git rrdcached
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The packages listed above are an all-inclusive list of packages that were
necessary on a clean install of Ubuntu 14.04.

### Post install configuration

#### snmp

You need to configure snmpd appropriately if you have not already done so. We
will do a minimal snmp configuration on our server -- _please *DON'T* do this if
you've already configured SNMP earlier!_

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# mv /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf.orig
# editor /etc/snmp/snmpd.conf
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

and, add the following line to the empty file:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
rocommunity NetManage 127.0.0.1
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

And, now restart the snmp service so that the changes become active.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# systemctl restart snmpd
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You can verify that snmp now responds to you locally by typing:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# snmpstatus -v2c -c NetManage 127.0.0.1 sysStatus
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#### php

In both ''/etc/php/7.0/apache2/php.ini'' and ''/etc/php/7.0/cli/php.ini'', ensure
''date.timezone'' is set to your preferred time zone.

See \<http://php.net/manual/en/timezones.php\> or files under
''/usr/share/zoneinfo'' for a list of supported timezones. For this workshop we
are all going to use the same timezone, that is **PLEASE USE** UTC only. If you
select anything other than UTC then other programs will not work properly.

In the two archives noted above find the line that reads:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;date.timezone =
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

and change it to:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
date.timezone = Etc/UTC
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Save and exit from the files.

 

Adding the LibreNMS user
------------------------

We need to create a LibreNMS system user, `librenms`

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# useradd librenms -d /opt/librenms -M -r
# usermod -a -G librenms www-data
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 

Cloning the LibreNMS source code with git
-----------------------------------------

LibreNMS is installed using git. If you're not familiar with git, check out the
[git book](https://git-scm.com/book/en/v2) or the tips at [git ready](http://gitready.com/). 
The initial install from github.com is called a ''git clone''; subsequent updates are done 
through ''git pull''.

The initial clone can take quite a while (nearly 3 minutes on a 10Mbps
connection is typical) as the size of the software repository is 220+ MB in
size.

Run the following:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# cd /opt
# git clone --depth 1 https://github.com/librenms/librenms.git librenms
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

At this point, you should have a ''librenms'' directory, with the most recent
revision checked out.

It's strongly suggested to check out the most recent stable.

To do this:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# cd librenms
# git tag
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Look for the most recent tag in the form `YYYYMM`, and then type:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# git checkout YYYYMM
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

For instance, if the newest tag is `201605`, then do `git checkout 201605`.
 

Web Interface
-------------

To prepare the web interface (and adding devices shortly), you'll need to create
and change the ownership of a directory as well as create an Apache Virtul Host
definition.

First, create and chown the ''rrd'' directory and create the ''logs'' directory:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# cd /opt/librenms
# mkdir rrd logs
# chown -R librenms:librenms /opt/librenms
# chmod 775 rrd
# chown www-data /opt/librenms
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Next, create ''/etc/apache2/sites-available/librenms.conf'':

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 # editor /etc/apache2/sites-available/librenms.conf
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Add the following lines:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
<VirtualHost *:80>
  DocumentRoot /opt/librenms/html/
  ServerAlias librenms*.ws.nsrc.org
  CustomLog /opt/librenms/logs/access_log combined
  ErrorLog /opt/librenms/logs/error_log
  AllowEncodedSlashes NoDecode
  <Directory "/opt/librenms/html/">
    Require all granted
    AllowOverride All
    Options FollowSymLinks MultiViews
  </Directory>
</VirtualHost>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


''mcrypt'' is not enabled on install. Run the following to enable it:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# phpenmod mcrypt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Now enable the Virtual Host, but wait to restart Apache

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# a2ensite librenms.conf
# a2enmod rewrite
# systemctl restart apache2
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Web installer
-------------

You can choose either a web configuration or manual configuration at the command
line. We're going to use the Web installer, which is by far the easiest.

At this stage you can launch the web installer by going to
<http://librenms.campusY.ws.nsrc.org/install.php>

Follow the onscreen instructions.

-   Stage 0 is a summary of the PHP modules installed, normally you should just
    click on ''Next Stage''

-   Stage 1 prompts you for the database settings. Enter

    -   DB Host: localhost

    -   DB User: librenms

    -   DB Pass: \<CLASS_PASSWORD\>

    -   DB Name: librenms

-   Stage 2 is the DB creating itself - it should finish correctly, and you
    simply click on ''Goto Add User'' at the bottom

-   Stage 3: enter a username, password and E-mail address. This will become the
    login you use to access the web interface.

We suggest you use ''admin'', the class password, and your own E-mail address.

-   Stage 4 should show you the successful user creation, click on ''Generate
    Config''

-   Stage 5: the interface should show, at this point:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
The config file has been created
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You can now click ''Finish install''.

Note: **IF** the installer tells you it can't write the configuration file, it
may be that you forgot to run ''chown www-data /opt/librenms''

You should try and fix the problem, and reload
<http://librenmsN.ws.nsrc.org/install.php>

See below if you still have problems.

-   Stage 6: you are done!

You can now follow the instructions and click where it says ''click here to
login to your new install''.

A useful tool is provided with LibreNMS to help verify that the software is
installed correctly.

Let's try it out:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# cd /opt/librenms
# ./validate.php
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You may see warnings about the software not being up to date, and some more
about permissions. You can probably ignore these for now, but it might come in
useful later if you experience issues with LibreNMS.

We can now secure the ''/opt/librenms'' directory again:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# chown librenms /opt/librenms
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


=\> YOU CAN NOW PROCEED TO THE FINE TUNING LAB ! \<=

### If you're still experiencing problems...

If it still doesn't work, you will need to copy the generated configuration 
displayed in the Browser window and place this in a new file:

''/opt/librenms/config.php'' 

using a text editor of your choice. (Remember if you are using "vi" to enter insert 
mode before you paste)
