---
title: LibreNMS
author: Campus Network Design Workshop
---

Configuring LibreNMS
====================

Goals
-----

-   Learn how to configure the LibreNMS Network Management System

Introduction
------------

In this exercise, we will set up **LibreNMS** as our network monitoring package.

### Connecting to your LibreNMS server

LibreNMS is running on your db server, that is you can connect to the server by going 
to:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
db.campusY.ws.nsrc.org
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You should do this for these first few steps, then when you are ready to view LibreNMS 
in your web browser you will go to:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
http://librenms.campusY.ws.nsrc.org
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

### Setting the SNMP community

First, let's change the SNMP community that LibreNMS will try when discovering
and adding new devices.

First, if you not already root, you should do:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo bash
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Next, edit the file */opt/librenms/config.php*,

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# editor /opt/librenms/config.php
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

and find the line:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$config['snmp']['community'] = array("public");
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

And change it to:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$config['snmp']['community'] = array("NetManage");
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 (this may already be done)

### Tell LibreNMS which subnets it's allowed to scan automatically

By default, LibreNMS will try ask for the list of “neighbors” that network
devices "see" on the network. This is done using the Link Layer Discovery
Protocol (LLDP) or Cisco's CDP (Cisco Discovery Protocol).

But to be on the safe side, and not scan networks outside your organization,
LibreNMS needs to be told which subnets it's allowed to scan for new devices.

Still in the file */opt/librenms/config.php*, find the lines that look like this:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#$config['nets'][] = "10.0.0.0/8";
#$config['nets'][] = "172.16.0.0/12";
#$config['nets'][] = "192.168.0.0/16";
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

And change this block of nets to look like:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$config['nets'][] = "100.68.Y.128/28";
$config['nets'][] = "172.2Y.0.0/16";
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Remember, to replace "Y" with your campus number.

We need to make one more change...

### Tell LibreNMS not to add duplicate devices

A situation can happen where two devices have duplicate SNMP *sysName*. (that's
*hostname* in IOS) They could be two different devices, so it would be a good
idea to have LibreNMS automatically add and monitor them.

But it can also happen that the SAME device is seen multiple times by LibreNMS -
once using LLDP/CDP, and another time via OSPF (for example).

In that case, it ends up added twice. For instance, you may suddenly see two
devices called *rtr2-fa0-0.ws.nsrc.org* and *rtr2*, and this is not what we
want.

Since "both" devices are in fact the same, their SNMP *sysName* will be
identical, and we can tell LibreNMS to **NOT** add devices if one already exists
with the same *sysName* - after all, this shouldn't happen in a well configured
network! :)

Here's an example of this:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
2016-07-06 20:16:47 rtr4 discovery Device rtr4 (10.10.0.224) (port FastEthernet0/0) autodiscovered through CDP on rtr1.ws.nsrc.org
2016-07-06 20:09:45 rtr4-fa0-0 discovery Device rtr4-fa0-0.ws.nsrc.org (10.10.0.224) (port ) autodiscovered through OSPF on rtr1-fa0-0.ws.nsrc.org
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

To avoid this, add the following line at the bottom of the config.php file:

(this may already be done)

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$config['allow_duplicate_sysName'] = false;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

... this will prevent LibreNMS from adding the device if it exists already with
the same *sysName*. You will be able to see if there are duplicate devices
deteced in the *Event Log* (Overview -\> Event Log).

After you've added the above setting, save the file and exit - we’re nearly
done!

 

### Add a host

Let's add localhost (i.e.: YOUR virtual server), using the following commands.
Later you'll do this from the Web interface:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# cd /opt/librenms
# php addhost.php localhost NetManage v2c
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You should see:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Added device localhost (1)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Notice we explicitly tell LibreNMS which SNMP community to use. We also assume
it's SNMP v2c. If you're using v3, there are additional steps which aren't
provided here.

Final Configuration
-------------------

### Discover and Poll newly added hosts

LibreNMS first “discovers” each host that has been added. This means that it
methodically examines each host you added and figures out what it should
monitor. The *discover.php* script does not automatically scan your network to
find new devices. To run this script do:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# cd /opt/librenms
# sudo -u librenms php discovery.php -h all
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**NOTE:** This could take some time. If you try to add devices that do not yet 
have an snmp service configured, then the discovery script takes a while to time
out.

Once this has finished you can now "poll" the hosts. This means LibreNMS now
knows what it wishes to monitor for each host, but it has yet to populate its
database with initial values for each item. To do this we do:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# sudo -u librenms php poller.php -h all
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

As you can see the *poller.php* script does quite a bit with just a few devices.
When we add it to a cronjob below this helps explain why LibreNMS is a resource
intensive tool.

### Create cronjob

Create the cronjob which will run periodic tasks required by LibreNMS:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# cd /opt/librenms
# cp librenms.nonroot.cron /etc/cron.d/librenms
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

One last thing: edit the file */etc/cron.d/librenms* ...

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# editor /etc/cron.d/librenms
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

...and find the line:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/5  * * * *  librenms  /opt/librenms/cronic /opt/librenms/poller-wrapper.py 16
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

And change the ''16'' at the end to ''4'' (we have a single processor, and 4
threads is plenty)

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/5  * * * *  librenms  /opt/librenms/cronic /opt/librenms/poller-wrapper.py 4
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Save, and exit.


Install complete
----------------

That's it! You now should be able to log in to
<http://librenms.campusY.ws.nsrc.org/> and begin to explore the information being
collected for your monitored devices.

You can add some additional devices via the LibreNMS web interface. Why not add:

-   bdr1.campusY.ws.nsrc.org
-   core1.campusY.ws.nsrc.org
-   dist1-b1.campusY.ws.nsrc.org
-   dist1-b2.campusY.ws.nsrc.org

What about your other servers? srv[1..6].campusY.ws.nsrc.org, db.campusY.ws.nsrc.org?

Using the class snmp community. See if you can figure out how to do this on your
own.

**NOTE**: When you first add a device it may end up in the "Generic" devices group. This is 
because LibreNMS needs to run it's cron job to poll all devices, obtain more specific device 
information and then classify the device in the proper group. This could take 5 to 10 minutes 
from the time you add the device.

**PLEASE NOTE**: We have not covered HTTPS setup in this example, so your
LibreNMS install is not secure by default. Please do not expose it to the public
Internet unless you have configured HTTPS and taken appropriate web server
hardening steps.

Customize your Installation
---------------------------

When you first log in to LibreNMS your default screen is empty. This is because you are 
allowed to edit your default screen using the Dashboard editing tool to make it look 
as you prefer. To do this do:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Click on the Edit Dashboard icon that looks like a Pencil next to a Red icon of a garbage 
can. 
* Name your Dashboard or leave it as "Default"
* If you select Private then your dashboard is only available to your user. 
* If you make it Shared (Read) then you control the look, but other can use it.
* If you make it just Shared, then anyone can update the look and feel of the dashboard.
* Click on Add Widgets and select items you would like to see by default when you log in.
 * Place the selected widget on the screen where you want it.
* You can click on the "X" to close the notice about editing dashboards so that it 
does not appear next time you log in.
* If you want specific graphs you can select the "Graph" widget and customize this.
* Many people use the Top-devices and Top-interfaces widgets.
 * For Top-interfaces note you can set the details on this widget. When done, press the "Set" button.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Remember, you can resize the widgets as you like.

When you are done press the "Update" button. Note that the top-devices and top-interfaces 
widgets will take some time before they populate with interesting information, so they 
will appear as largely blank for a while.

If you create multiple Dashboards you can switch between your default log in Dashboard by 
going to the person icon, selecting "My Settings" and going down to "Default Dashboard".


View a Real-Time Graph on an Interface
--------------------------------------

In the LibreNMS interface do:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Select Devices ==> All Devices ==> Server
* Select a server from the resulting screen (click on it's name)
* Click on the "Ports" item near the top.
* Click on network interface "eth0"
* Next to the Graphs item select "Real time"
* Select a "Polling Interval" that is long enough to see information. 
 * Click on "60s"
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If you do not see any traffic, go to that server and do something... Like, 

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ ping srvX.campusY.ws.nsrc.org
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Or some other device or machine, or run an apt-get update, etc...

## A few other items

Creating an Alert
------------------

From top LibreNMS menu you can start creating an alert by click on the "Alerts" menu 
item, then:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Click on Rules
* Click the box that says: "Click here to create the default alert rules"
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Now you wil have a sample alert collection you can work from. You can always create your 
own custom alert, but having this collection helps to figure out how to do this.


Global Frontpage Map
-------------------

It is possible to create a global map of all your entries that is displayed by LibreNMS.
If you are interested you can view the LibreNMS documentation on this at:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* http://docs.librenms.org/Extensions/Globe-Frontpage/
* http://docs.librenms.org/Support/SNMP-Configuration-Examples/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You must use the sysLocation snmp variable on your servers and network devices providing 
latitude and longitude information for each item for this to work.


About Daily Updates
-------------------

LibreNMS performs daily updates by default. At 00:15 system time every day, a
*git pull --no-edit --quiet *is performed. If you don't want this, change the
default by editing your ''config.php'' file. Remove the comment (the ''\#''
mark) on the line:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#$config['update'] = 0;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

so that it looks like this:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$config['update'] = 0;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
