# Netdot exercise

# Introduction

The Network Documentation Tool (Netdot) is an open source software designed to 
help network administrators collect, organize and maintain network 
documentation. Netdot is actively developed at the University of Oregon.

## Goals

In these exercises we will install Netdot and demonstrate some of its most
important features. 

## Notes

* Commands preceded with "$" imply that you should execute the command as
  a general user - not as root.
* Commands preceded with "#" imply that you should be working as root.
* Commands with more specific command lines (e.g. "rtrX>" or "mysql>") 
  imply that you are executing commands on remote equipment, or within 
  another program.

# Installation

_Netdot may already be installed in your campus server. Ask the instructor._

Log in to your virtual machine as the sysadm user.

## Download the Package

First check if it's available in your classroom's NOC server:

~~~
$ cd 
$ wget http://www.ws.nsrc.org/downloads/netdot/netdot-1.0.7.tar.gz
~~~
If not, try from the official site:

~~~
$ wget http://netdot.uoregon.edu/pub/dists/netdot-1.0.7.tar.gz
~~~
Unpack the tarball:

~~~
$ tar xzvf netdot-1.0.7.tar.gz
$ cd netdot-1.0.7
~~~
## Install dependencies:

~~~
$ sudo apt-get install build-essential
$ sudo make apt-install

Which RDBMS do you plan to use as backend: [mysql|Pg]? mysql

We need to add a temporary repository of Netdot dependencies until all packages 
are in Debian/Ubuntu official repositories.
Would you like to continue? [y/n] y
~~~
This will download a lot of packages. Be patient.

(If you had not installed mysql-server, you'll be asked for a DBA password.
Ask the instructor for the Mysql root password).

Say yes here:

~~~
We will install the MIB files now. Continue? [y/n] y
~~~
If you see this prompt, then answer yes:

~~~
A new /etc/snmp/snmp.conf needs to be installed to point to the newly 
installed MIB files. The current file will be backed up. Continue? [y/n] y
~~~
At the end of the installation you will see a list of Perl modules that 
have been installed (OK). If any did not install you will see "MISSING". 

-----------------------------------------------------------------------------

> **NOTE** If more than two packages show as MISSING, do not continue. Ask your
> instructor for help. Probably you will need to go back and repeat the last section
> (`sudo make apt-install`) and look for errors.

-----------------------------------------------------------------------------

If one or two packages are missing, type:

~~~
$ sudo make installdeps

Which RDBMS do you plan to use as backend: [mysql|Pg]? mysql
~~~
You will now see three questions concerning CPAN setup to download the missing 
PERL dependency. Answer like this:

~~~
Would you like to configure as much as possible automatically? [yes] yes

What approach do you want?  (Choose 'local::lib', 'sudo' or 'manual')
 [local::lib] <ENTER>
 
Would you like me to automatically choose some CPAN mirror
sites for you? (This means connecting to the Internet) [yes] 
~~~
If you still see missing dependencies do:

~~~
$ sudo make installdeps
~~~
Until you don't see any more missing dependencies.

This will try to install the missing modules using the CPAN archive. At the
end, all the modules should show "ok".

## Initialize the site configuration:

~~~
$ cd ~/netdot-1.0.7/
$ cp etc/Default.conf etc/Site.conf
$ editor etc/Site.conf
~~~
  Find and change the following values:

~~~
NETDOTNAME => 'srvX.campusY.ws.nsrc.org',
DB_DBA_PASSWORD => '(the password you used when installing mysql)',
DEFAULT_SNMPCOMMUNITIES  =>  ['NetManage', 'public'],
NMS_DEVICE => 'srvX.campusY.ws.nsrc.org',
DEFAULT_DNSDOMAIN  => 'ws.nsrc.org',
DEVICE_NAMING_METHOD_ORDER => [ 'sysname', 'snmp_target' ],
~~~
Save and exit from the file.

## Patch installation

We're going to make a couple of changes: one to speed up download of
the ethernet vendor file, and another to make netdot work with apache 2.4

First, let's make netdot download the list of ethernet vendors from our
local server, and not from the internet (it takes too long otherwise):

~~~
$ cd ~/netdot-1.0.7/bin/
$ editor Makefile
~~~
Find the line:

    wget -t 1 http://standards.ieee.org/regauth/oui/oui.txt || cp oui.txt.default oui.txt

And change it to:

    wget -t 1 http://www.ws.nsrc.org/downloads/netdot/oui.txt || cp oui.txt.default oui.txt


## Install the application and initialize the database.

It's finally time to run the installation!

~~~
$ cd ~/netdot-1.0.7/
$ sudo make installdb
$ sudo make install APACHEUSER=www-data APACHEGROUP=www-data
$ sudo ln -s /usr/local/netdot/etc/netdot_apache24_local.conf \
	/etc/apache2/conf-available/netdot.conf
$ sudo a2enconf netdot
$ sudo service apache2 graceful
~~~
Install the cron jobs for automated tasks

~~~
$ sudo cp netdot.cron /etc/cron.d/netdot
~~~
# Operation

## Log into the web interface

In your browser, go to:

~~~
http://srvX.campusY.ws.nsrc.org/netdot
~~~
Log in with username: admin and password: admin

## Changing default passwords

Netdot comes with three default user accounts. You should change the default
passwords on those. 

Go to the "Contacts" tab, then search for "Admin". You should see the details
for the Admin user. Click on [edit], and find the Password field. Type the
password you used to log in to your server, then click on the "Update" button.

Repeat the same steps for the other default users:

* operator
* guest

## Discovering devices

If you have not done so yet, configure SNMP on your server and your router.

**Ask the instructor to provide you with instructions for configuring SNMP
on Cisco routers and Linux**

Now back to Netdot. Let's create a file with all the devices in the lab network 
that respond to SNMP:

~~~
$ editor /home/sysadm/discoverme.txt
~~~
Copy and paste the list below. You will need to change "Y" to your campus number

~~~
bdr1.campusY.ws.nsrc.org
core1.campusY.ws.nsrc.org
dist1-b1.campusY.ws.nsrc.org
dist1-b2.campusY.ws.nsrc.org
srv1.campusY.ws.nsrc.org
srv2.campusY.ws.nsrc.org
srv3.campusY.ws.nsrc.org
srv4.campusY.ws.nsrc.org
srv5.campusY.ws.nsrc.org
srv6.campusY.ws.nsrc.org
db.campusY.ws.nsrc.org
~~~
Now, tell Netdot to discover those devices:

~~~
$ cd /usr/local/netdot
$ sudo bin/updatedevices.pl -E /home/sysadm/discoverme.txt -IAF
~~~
When that is done, go to the web interface and navigate to 

    Management -> Devices

Leave the search box empty, and click on the "Find" button.

You should see all the discovered devices in that list. Go to the link for your 
group's router (e.g. rtrX.ws.nsrc.org)

* Navigate to all the tabs: Basic, Interfaces, Modules, IP Info, etc. 
  Netdot allows you to augment the information gathered from the device
  with details entered manually.

* In the ARP section, you should see one entry with a timestamp.
  Click on that entry. You should see a table associating IP addresses
  with MAC addresses. This is the ARP table discovered from rtr1. You should
  see your servers's IP address and MAC address.


## Finding a computer in your network

* Obtain the MAC address from your laptop (or desktop). Copy it in the clipboard.
* In the Netdot web interface, go to Management -> Devices
* Paste your MAC address and hit ENTER

Netdot will show you which devices were seeing that MAC address the last
time that it discovered the network.

## Managing IP address space

Go to Management -> Address Space

You should see a list of private IP blocks (from RFC-1918). These come
pre-installed in Netdot. 

Click on 10.0.0.0/8

You will see a list of discovered IP blocks, which are marked as "Subnets".
These were found in routers. 

* Click on 100.68.Y.0/24. 
* Click on [edit]
* In the Description field, type "Campus Y Serverss"
* Click "Save"

### Create a container to include all the group subnets

In the section called "Address Space Tasks" on top, click on the "[new]"
button and enter the following:

* IP/Prefix: 100.68.Y.0/24
* Owner: click on [new]. 
* In the new "Entity" window, enter:
  * Name: NSRC Lab
  * Insert button, then [close]
* Used by: (leave blank)
* Status: Container
* Description: NSRC lab student networks
* Save 

You should now see the new Container page. It shows a graphical representation
of the /16 block. All the existing subnets are shown in red. The green space
represents unused or available address space.

* On the top of the graph there is a section called "Zoom: set one row equal to"
  Select /24 from the drop-down menu. Each row now represents a /24 block
* Click on [Tree View] to see a tree graph view of the IP hierarchy

## Polling devices

Periodically you will want to connect again to your routers and switches to
fetch their routing tables, forwarding tables etc. You can run the command which
does this:

~~~
$ sudo /usr/local/netdot/bin/updatedevices.pl -DIFAT
~~~

* -D: poll all devices already in the database
* -I: get device info (e.g. sysName)
* -F: get switch forwarding tables
* -A: get router ARP tables
* -T: re-calculate the topology

To avoid having to run this by hand, you can install a crontab which will
do it automatically at set times of day. We installed the crontab file in 
/etc/cron.d previously. If you look in /etc/cron.d/netdot you will see that
this command executes once each hour by default.


# More information

[Official Netdot Website](http://netdot.uoregon.edu)

