# Setting up Jitter in the RANCID CRON process

## Creating Jitter

When you installed and configured RANCID you were asked to create the RANCID cron file:

~~~
/etc/cron.d/rancid
~~~

That file should look like:

~~~
# run config differ hourly
#1 * * * * rancid /usr/bin/rancid-run
# clean out config differ logs
#50 23 * * * rancid find /var/log/rancid -type f -mtime +2 -exec rm {} \;
*/30 * * * * rancid /usr/lib/rancid/bin/rancid-run
~~~

The very last line that starts with "*/30" means that RANCID will run and backup your 
network devices every 30 minutes.

We need to set up some "jitter" between our RANCID processes. You do not need to do this 
outside of this lab, so you can leave the /etc/cron.d/rancid file as it is if you decide 
to install RANCID at home.

Below is a list of each server machine in our classroom and what the last line should 
look like for that server. Please find your machine and update /etc/cron.d/rancid's last 
line to look like what is in the table below:

### Campus 1

| LAST LINE in /etc/cron.d/rancid                    | SERVER                   |
|----------------------------------------------------|--------------------------|
| 1 * * * * rancid /usr/lib/rancid/bin/rancid-run    | srv1.campus1.ws.nsrc.org |
| 2 * * * * rancid /usr/lib/rancid/bin/rancid-run    | srv2.campus1.ws.nsrc.org |
| 3 * * * * rancid /usr/lib/rancid/bin/rancid-run    | srv3.campus1.ws.nsrc.org |
| 4 * * * * rancid /usr/lib/rancid/bin/rancid-run    | srv4.campus1.ws.nsrc.org |
| 5 * * * * rancid /usr/lib/rancid/bin/rancid-run    | srv5.campus1.ws.nsrc.org |
| 6 * * * * rancid /usr/lib/rancid/bin/rancid-run    | srv6.campus1.ws.nsrc.org |

### Campus 2

| LAST LINE in /etc/cron.d/rancid                    | SERVER                   |
|----------------------------------------------------|--------------------------|
| 11 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv1.campus2.ws.nsrc.org |
| 12 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv2.campus2.ws.nsrc.org |
| 13 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv3.campus2.ws.nsrc.org |
| 14 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv4.campus2.ws.nsrc.org |
| 15 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv5.campus2.ws.nsrc.org |
| 16 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv6.campus2.ws.nsrc.org |

### Campus 3

| LAST LINE in /etc/cron.d/rancid                    | SERVER                   |
|----------------------------------------------------|--------------------------|
| 21 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv1.campus3.ws.nsrc.org |
| 22 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv2.campus3.ws.nsrc.org |
| 23 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv3.campus3.ws.nsrc.org |
| 24 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv4.campus3.ws.nsrc.org |
| 25 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv5.campus3.ws.nsrc.org |
| 26 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv6.campus3.ws.nsrc.org |


### Campus 4

| LAST LINE in /etc/cron.d/rancid                    | SERVER                   |
|----------------------------------------------------|--------------------------|
| 31 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv1.campus4.ws.nsrc.org |
| 32 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv2.campus4.ws.nsrc.org |
| 33 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv3.campus4.ws.nsrc.org |
| 34 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv4.campus4.ws.nsrc.org |
| 35 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv5.campus4.ws.nsrc.org |
| 36 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv6.campus4.ws.nsrc.org |


### Campus 5

| LAST LINE in /etc/cron.d/rancid                    | SERVER                   |
|----------------------------------------------------|--------------------------|
| 41 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv1.campus5.ws.nsrc.org |
| 42 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv2.campus5.ws.nsrc.org |
| 43 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv3.campus5.ws.nsrc.org |
| 44 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv4.campus5.ws.nsrc.org |
| 45 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv5.campus5.ws.nsrc.org |
| 46 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv6.campus5.ws.nsrc.org |


### Campus 6

| LAST LINE in /etc/cron.d/rancid                    | SERVER                   |
|----------------------------------------------------|--------------------------|
| 51 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv1.campus6.ws.nsrc.org |
| 52 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv2.campus6.ws.nsrc.org |
| 53 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv3.campus6.ws.nsrc.org |
| 54 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv4.campus6.ws.nsrc.org |
| 55 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv5.campus6.ws.nsrc.org |
| 56 * * * * rancid /usr/lib/rancid/bin/rancid-run   | srv6.campus6.ws.nsrc.org |

