# Network Management & Monitoring - Smokeping - Part I

In this exercise you will install Smokeping and get it to monitor various
devices in the class network.

Since most of the tasks in this exercise require you to be "root", the
first thing you should do is to connect to your PC and start a root shell.


    $ sudo -s
    #


## Install Smokeping



    # apt-get install smokeping

For Ubuntu 16.04, you need to make 'fping' setuid root so it can be run
by the smokeping poller.

    # chmod u+s /usr/bin/fping

For Ubuntu 14.04 (but not 16.04): you need to install a symlink to the apache2 config

    # ln -s /etc/smokeping/apache2.conf /etc/apache2/conf-available/smokeping.conf
    # a2enconf smokeping

Also, the CGI module needs to be enabled in Apache:

    # a2enmod cgi

Finally, reload the Apache configuration:

    # service apache2 reload

Then point your web browser at

    http://srvN.campusN.ws.nsrc.org/smokeping/smokeping.cgi

(replace "srvN" and "campusN" with your own PC) to check that it is running.


## Initial Configuration


    # cd /etc/smokeping/config.d
    # ls -l

    -rwxr-xr-x 1 root root  578 2010-02-26 01:55 Alerts
    -rwxr-xr-x 1 root root  237 2010-02-26 01:55 Database
    -rwxr-xr-x 1 root root  413 2010-02-26 05:40 General
    -rwxr-xr-x 1 root root  271 2010-02-26 01:55 pathnames
    -rwxr-xr-x 1 root root  859 2010-02-26 01:55 Presentation
    -rwxr-xr-x 1 root root  116 2010-02-26 01:55 Probes
    -rwxr-xr-x 1 root root  155 2010-02-26 01:55 Slaves
    -rwxr-xr-x 1 root root 8990 2010-02-26 06:30 Targets

The files that you'll need to change, at a minimum, are:

* Alerts
* General
* Probes
* Targets

Now open the General file (note the first capital letter)

    # nano General

Change the following lines:

~~~
owner    = NOC
contact  = sysadm@localhost
mailhost = localhost
cgiurl   = http://localhost/smokeping/smokeping.cgi
# specify this to get syslog logging
syslogfacility = local5
~~~

Save the file and exit. Now let's restart the Smokeping service to verify
that no mistakes have been made before going any further:

    # systemctl stop smokeping
    # systemctl start smokeping

A quicker way to do this is:

    # systemctl restart smokeping

We'll use this for the rest of the exercises, or we'll just use the "reload"
directive as this is all you need for Smokeping to see configuration file
changes.

Now open the Alerts file (note the first capital letter)

    # cd /etc/smokeping/config.d
    # nano Alerts

Change the following lines:

~~~
to = root@localhost
from = smokeping-alert@localhost
~~~

Save the file and exit. Restart Smokeping:

    # systemctl restart smokeping

## Configure monitoring of devices


The majority of your time and work configuring Smokeping will be done in the
file /etc/smokeping/config.d/Targets.

For this class please do the following:

Use the default FPing probe to check:

- some of the student PCs
- classroom NOC
- switches
- routers

You can use the classroom Network Diagram on the classroom wiki to figure out addresses for each item, etc.

Create some hierarchy to the Smokeping menu for your checks. 

For example, the Targets file is already partially pre configured. To start we are going to add some entries to this file. 

Start with:

    # cd /etc/smokeping/config.d
    # nano Targets

You can take the section from `*** Targets ***` to the end of the LocalMachine and make it look something like this. Feel free to use your own "remark", "menu" text and titles. 

Note that we remove the commented lines `#parents = owner:/Test/James location:/`, and the "Alerts" line.

NOTE: We strongly recommend that you COPY and PASTE text from these exercises directly in to the
Targets file. Typing all this by hand will take too long.

~~~
*** Targets ***

probe = FPing

menu = Top
title = Network Latency Grapher
remark = Smokeping Latency Grapher for Network Monitoring \
         and Management Workshop.

+Local

menu = Local Network Monitoring and Management
title = Local Network

++LocalMachine

menu = Local Machine
title = This host
host = localhost
~~~

Now, below the "localhost" we start with the configuration of items for our class.

We can start simple and add just the first 4 Servers that are in Campus 1 as well as an entry for our classroom NOC.

~~~
#
# ********* Classroom Servers **********
#

+NOCServers

menu = NOCServers
title = Network Management Servers

++noc

menu = noc
title = Workshop NOC
host = noc.ws.nsrc.org

#
# ******** Student Machines (VMs) ***********
#

+Campus1

menu = Campus 1 Servers
title = Virtual Servers in Campus 1

++server1

menu = server1
title = Campus 1 Server 1
host = srv1.campus1.ws.nsrc.org


++server2

menu = server2
title = Campus 1 Server 2
host = srv2.campus1.ws.nsrc.org


++server3

menu = server3
title = Campus 1 Server 3
host = srv3.campus1.ws.nsrc.org


++server4

menu = server4
title = Campus 1 Server 4
host = srv4.campus1.ws.nsrc.org
~~~

OK. Let's see if we can get Smokeping to stop and start with the changes we have made, so far. Save and exit from the Targets file. Now try doing:

    # systemctl restart smokeping

If you see error messages, then read them closely and try to correct the problem in the Targets file. In addition, Smokeping is now sending log message to the file /var/log/syslog. You can view what Smokeping is saying by typing:

    # tail -F /var/log/syslog

If you want to see all smokeping related messages in the file /var/log/syslog you can do this:

    # grep smokeping /var/log/syslog

If there are no errors you can view the results of your changes by going to:

    http://srvN.campusN.ws.nsrc.org/cgi-bin/smokeping.cgi

When you are ready you can edit the Targets file again and continue to add machines.

At the bottom of the file you can add the other Campuses of Servers:

~~~
+Campus2

menu = Campus 2 Servers
title = Virtual Servers in Campus 2

++server1

menu = server1
title = Campus 2 Server 1
host = srv1.campus2.ws.nsrc.org


++server2

menu = server2
title = Campus 2 Server 2
host = srv2.campus2.ws.nsrc.org


++server3

menu = server3
title = Campus 2 Server 3
host = srv3.campus2.ws.nsrc.org


++server4

menu = server4
title = Campus 2 Server 4
host = srv4.campus2.ws.nsrc.org
~~~


Add as many PCs as you want, then Save and exit from the Targets file and verify that the changes you have made are working:

    # systemctl restart smokeping

You can continue to view the updated results of your changes on the Smokeping web page. It may take up to 5 minutes before graphs begin to appear.

    http://srvN.campusN.ws.nsrc.org/cgi-bin/smokeping.cgi



## Configure monitoring of routers and switches


Once you have configured as many PCs as you want to configure, then it's time to add in some entries for the classroom routers and switch(es).

    # cd /etc/smokeping/config.d		(just to be sure :-))
    # nano Targets

Go to the bottom of the file and add in some entries for routers and switches:


~~~
#
# ********** Classroom Backbone Switch *********
#

+Switches

menu = Switches
title = Switches Network Management

++sw

menu = sw
title = Backbone Switch
host = sw.ws.nsrc.org

#
# ********** Virtual Routers: Cisco 7200 images *********
#

+Routers

menu = Routers
title = Virtual and Physical Routers Network Management

++gw

menu = gw
title = Gateway Router
host = gw.ws.nsrc.org

#
# ********** Campus Border Routers *********
#

++border
menu = Border
title = Border Routers

+++campus1
menu = campus1
title = Border Router Campus 1
host = bdr1.campus1.ws.nsrc.org

+++campus2

menu = campus2
title = Border Router Campus 2
host = bdr1.campus2.ws.nsrc.org

+++campus3

menu = campus3
title = Border Router Campus 3
host = bdr1.campus3.ws.nsrc.org

#
# ********** Campus Core Routers *********
#

++core
menu = Core
title = Core Routers

+++campus1
menu = campus1
title = Core Router Campus 1
host = core1.campus1.ws.nsrc.org

+++campus2

menu = campus2
title = Core Router Campus 2
host = core1.campus2.ws.nsrc.org

+++campus3

menu = campus3
title = Core Router Campus 3
host = core1.campus3.ws.nsrc.org

~~~


If you wish you can continue and add in entries for routers 4 to 6, or up to 6 campuses if there are that many in your class. When you are ready Save and Exit from the Targets file and verify your work:

    # systemctl restart smokeping
    # tail -F /var/log/syslog

If you want you might consider adding the Wireless Access Point:

    # nano Targets


~~~
#
# Classrom Wireless Access Point
#

++ap1

menu = ap1
title = Wireless Access Point 1
host = ap1.ws.nsrc.org
~~~

Save and Exit from the file and reload the Smokeping service:

    # systemctl restart smokeping
    # tail -F /var/log/syslog
