﻿% Network Management & Monitoring

# Request Tracker (RT) Installation and Configuration

## Notes: 

* Commands preceded with "$" imply that you should execute the command as a
  general user - not as root.
* Commands preceded with "#" imply that you should be working as the root
  user.
* Commands with more specific command lines (e.g. `bdr1>` or `mysql>`)
  imply that you are executing commands on remote equipment, or within
  another program.
*  If a command line ends with "\" this indicates that the command continues
  on the next line and you should treat this as a single line.

# Exercises

## Exercise 0

Log in to your virtual machine as the sysadm user.

## Exercise 1

Install the necessary packages for RT. You should have mysql-server
already, but we do the install just in case. This won't cause problems.

Copy the "sudo apt-get install" line below, minus the "$" and paste this
in to your terminal session on your virtual machine.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo apt-get install rt4-apache2 rt4-clients rt4-db-mysql request-tracker4 \
  libapache2-mod-fastcgi libfcgi-perl mutt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Respond "Yes" when prompted if you wish to install the packages.

You will now be presented with several windows. Read the follwing
instructions to see how to respond:

**Name for this Request Tracker (RT) instance:**

Remove what is shown and replace with "netmgmt", then select `<Ok>` and
press `ENTER` to continue.

![RT installation name](images/01-configure-rt-name.png)

**Handle RT_SiteConfig.pm permissions?**

* Select `<Yes>` and press ENTER to continue.

**Configure database for request-tracker4 with dbconfig-common?**

* Select `<Yes>` and press ENTER to continue.

![DB configuration](images/02-configure-rt-db.png)

**Password of the database's administrative user:**

Enter the MySQL **`root`** or **`admin`** password. This was set earlier in
the workshop (probably when you installed Cacti). If you do not remember
what this is, or if it's not written at the front of the classroom, ask
an instructor for help.

![DB admin password](images/03-configure-rt-db2.png)


**MySQL application password for request-tracker4:**

You may enter any password you wish. This will be used by Request Tracker to
connect to MySQL. You generally do not need to remember this password. Pick
something that cannot be guessed easily (i.e., don't use `rt`,
`requesttracker`, `1234`, etc...).

![DB application password](images/04-configure-rt-db-pwd.png)

**Password confirmation:**

* Enter the same password that you created in the previous step.

![DB application password](images/05-configure-rt-pwd2.png)

**Initial root password for RT system:**

* Use the same password as we used for the MySQL database administrative user.

![Initial root password](images/06-configure-rt-db-pwd3.png)

Now you will see quite a bit of information go across your screen as
the Request Tracker installation process completes - It's a big package.

## Exercise 3

At this point you have installed Request Tracker version 4. In order
to access RT via the Apache web server you need to make a few small
changes.

First let's update the Requestion Tracker (RT) configuration to improve the "From:" 
field format that will be used when RT sends out emails to users. In addition we will 
restrict attachment sizes and we will add our RT server to a whitelist to avoid cross 
site forgery error messages for legitimate RT usage.

Request Tracker maintains configuration files in the directory:

/etc/request-tracker4/RT_SiteConfig.d

We will go to this directory, create a new configuration file called 90-local and 
regenerate the RT RT_SiteConfig.pm file using the update-rt-siteconfig command:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ cd /etc/request-tracker4/RT_SiteConfig.d
$ sudo editor 90-local
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Add the following two lines to the file 90-local:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Set($MaxAttachmentSize , 10000000);
Set(@ReferrerWhitelist, qw(x.x.x.x:80  SERVNAME:80));
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


In the ReferrerWhitelist entry x.x.x.x. is the IP address of your PC and SERVNAME is 
the name of your Server. That is, if you are on srv1.campus1.ws.nsrc.org you would enter:

~~~
Set(@ReferrerWhitelist, qw(100.68.1.131:80  srv1.campus1.ws.nsrc.org:80));
~~~

Be sure to use the correct IP address and name for your Server, then save the file 
and execute the command:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo update-rt-siteconfig
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Now we have one more change to the Apache web server configuration to make:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ cd /etc/apache2/conf-available
$ sudo ln -s /etc/request-tracker4/apache2-modperl2.conf rt4.conf
$ sudo a2enconf rt4 
$ sudo service apache2 restart
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The last step could take up to 30 seconds, so be patient! RT should now be up and running!

