﻿% Network Management & Monitoring

# Request Tracker (RT) Installation and Configuration

## Notes: 

* Commands preceded with "$" imply that you should execute the command as a
  general user - not as root.
* Commands preceded with "#" imply that you should be working as the root
  user.
* Commands with more specific command lines (e.g. `RTR-GW>` or `mysql>`)
  imply that you are executing commands on remote equipment, or within
  another program.
*  If a command line ends with "\" this indicates that the command continues
  on the next line and you should treat this as a single line.

# Exercises

## Exercise 0

The Request Tracker software has already been installed on your server. You may refer to 
the RT Install Guide in your course Agenda for details on how to install Request Tracker 
on your own.

## Exercise 1

(This exercises should be done by each person your group).

Log in to RT as the root User

If you go to <http://db.campusY.ws.nsrc.org/rt/> you will see the RT login screen:

![Login screen](images/08-rt-login.png)

Enter the following information to log in as **`root`** on RT:

**Username:** `root`

**Password:** [SELECTED AT INSTALL]

## Exercise 2

**RT Configuration: Create your User**

(This exercises should be done by each person your group).

Now that you are logged in we will create a new user for the rest of
these exercises. The user you will create is "sysadm-serverX".

On the top of the screen choose **Admin** => **Users** => **Create** and then click on 
the **Create** item in the menu.

![Create User](images/09-rt-user-create.png)

You will now be presented with the following dialogue. Fill in the
fields, and make sure the checkbox **`Let this user be granted rights`**
is checked. Set your email to `sysadm@`**`srvX.CampusY`**`.ws.nsrc.org` - Replace X with your 
user and Y with your campus.

![User creation form](images/10-rt-user-create2.png)

Use the same password for **`sysadm-serverX`** as you are using in class. Be sure
you check **`Let this user be granted rights`**. Once done, scroll down the
page and click on the **Create** button (bottom right). You should see this:

![User created](images/11-user-create3.png)

## Exercise 3

**NOTE**: Only 1 person should do this. You need to coordinate with your team and wait 
until everyone has create their user, before going on.

**RT Configuration: Create a Group**

* At the top, choose the menu item **Admin** => **Groups** => **Create**

![Create group](images/12-group-create.png)

* Fill in the name: `netmgmt`, and add a description, then click on **Create**

![Create group form](images/13-group-create2.png)

* You should see the following result:

![Group created](images/14-group-create3.png)

* Click on Members (top menu)

![Group members](images/15-group-member.png)

* In the **`Add user`** field (right), type in the name of one of the users 
you have created in step 3. This is the **`sysadm-serverX`** user. Then click on **Modify
Members** (bottom right):

![Add member](images/16-group-member2.png)

* You should see this:

![Member added](images/17-group-member3.png)

No repeat this for each member of your group until you have added all users.

## Exercise 4

(Only one person should do this)

**RT Configuration: Create a New Queue**

* At the top, choose the menu item
**Tools** => **Configuration** => **Queue** => **Create**

![Create queue](images/18-queue-create.png)

* Fill in the fields. Let's use the following values and then click on
**Create**:

**Queue Name:**			`net`

**Description:**		`Network Problems`

**Subject Tag:**		`RT: NET`

**Reply Address:**		`net@pcX.ws.nsrc.org`

**Comment Address:**	`net-comment@pcX.ws.nsrc.org`

![Queue create form](images/19-queue-create2.png)

**Note:** Remember to replace pcX with the correct number of your machine

You should see this:

![Queue created](images/20-queue-create3.png)

## Exercise 5

(Only one person should do this)

**RT Configuration: Give Rights to our Group on the Queue**

From the top menu, select
**Admin** => **Queues** => **Select**

You should see:

![Enabled Queues](images/21-queues.png)

* Click on **`net`** then choose **`Group Rights`** (top right)

![Group rights](images/22-queue-group-rights.png)

The following page should look like this:

![Group rights overview](images/23-queue-group-rights2.png)

Note the three categories: **General rights**, **Rights for Staff**,
**Rights for Administrators**

Here, we want to give **Everyone** (including people who are not yet known
to RT) some privileges, but only the minimum required. These are found under
**General Rights**, and are the following:

* **Create tickets**  		**`(CreateTicket)`**
* **Reply to tickets**		**`(ReplyToTicket)`**
* **View queue**			**`(SeeQueue)`**
* **View ticket summaries**	**`(ShowTicket)`**

So start by selecting these 4 privileges by checking the 4 boxes in
your browser.

Notice that **Everyone** on the left is already highlighted.

![Modify group rights](images/24-queue-group-rights3.png)

Now, click **Save Changes** (bottom right) to make sure the changes are
applied.

![Saved rights](images/25-queue-group-rights4.png)

Staying on the same page, we're going to now give the **netmgmt** Group
all rights...

To do this, first type in the name of the group in the **ADD GROUP**
field in the lower left:

![Add rights to group](images/26-queue-group-rights5.png)

Now check **ALL** the boxes in **General Rights**, **Rights for Staff**,
**Rights for Administrators**.

![All rights selected](images/27-queue-group-rights6.png)

Once this is done, press the **Save Changes** button on the bottom right
of the page. You should see:

![Rights granted](images/28-queue-group-rights7.png)

## Exercise 6

(Everyone does this exercise)

**RT Configuration: Log in as sysadm-serverX**

Log out of RT (top menu, select the item **Logged in as root** => **Logout**)

![Logging out](images/29-logout.png)

Now log back in as the **`sysadm-serverX`** user you have created:

![Logging in as `sysadm`](images/30-login-newuser.png)

You should see the following:

![Main page view for `sysadm`](images/31-rt-at-a-glance.png)

At this point RT has been properly configured for initial operation.
Now we must configure email properly to talk with our new `net` queue in RT.

## Exercise 7

(Only one person does this exercise)

**RT Configuration: Email**

RT will work with the MTA (Mail Transfer Agent) of your choice.
In our case we are using Postfix configured to run as an MTA for an
<<**Internet Site**>> - that is, to deliver email locally and remotely using
SMTP.

First, we need to verify that the file /etc/mailname has the correct entry.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo editor /etc/mailname
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Be sure that the only entry in this file is:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
db.campusY.ws.nsrc.org
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Where "Y" is your campus number. Once you have updated the file or verified it is 
correct save your changes (if any) and exit from the file.

Next we will edit the file /etc/aliases

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo editor /etc/aliases
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Add the following two lines at the end of the file (copy and paste!):

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
net-comment: "|/usr/bin/rt-mailgate --queue net --action comment --url http://localhost/rt/"
net:        "|/usr/bin/rt-mailgate --queue net --action correspond --url http://localhost/rt/"
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Save the file and exit. Some editors might cause the above-lines to
become multiple lines. Be sure that you only have two new lines in your
`/etc/aliases` file after copying and pasting in the text above.

Now run the command:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo newaliases
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

## Exercise 8

**RT Configuration: Create an Email and Tickets**

(Only one person does this)

Let's create an email and send it to the RT **`net`** queue. Do this as
the `sysadm` user (not as `root`!):

If you are currently `root`:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# su - sysadm

$ echo "Problem with my router" | mail -s "Router problem" net@db.campusY.ws.nsrc.org
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Remember to replace the "Y" in "campusY" with your campus number.

If you get an error about mail not being installed, then do:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo apt install mailutils
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

And run the "echo" command above again.

Now check that you have received email:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ mutt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

You should see an email from Request Tracker acknowledging that your
ticket has been created.

Select that email and press <ENTER>

The mail should say something similar to this:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Date: Fri, 24 Feb 2017 00:21:19 +0000
From: Network Problems via RT <net@db.campus6.ws.nsrc.org>
To: sysadm@db.campus6.ws.nsrc.org
Subject: [RT: NET #2] AutoReply: Router problem

Greetings,

This message has been automatically generated in response to the creation of a
trouble ticket regarding Router problem, a summary of which appears below.

There is no need to reply to this message right now. Your ticket has been
assigned an ID of [RT: NET #2].

Please include the string [RT: NET #2] in the subject line of all future
correspondence about this issue. To do so, you may reply to this message.

Thank you,
net@db.campus6.ws.nsrc.org

---------------------------------------------------------------------------

Problem with my router
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If, for some reason, you do not see mail try taking these steps, and
then send the mail again:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ sudo touch /var/mail/sysadm
$ sudo chown sysadm:mail /var/mail/sysadm
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Once you read the mail press the "q" key twice to exit from mutt.

## Exercise 9

(Select one member of your group to do this. Everyone can see the ticket, but only 
one person should edit it at one time).

**RT Configuration: View, Reply, Resolve, Reopen Tickets in Request Tracker**

Go back to your web browser where you are logged in to RT as the
sysadm-serverX user and click on the **Home** menu item (top left).

You should then be presented with an updated view with the current ticket:

![Main page - ticket overview](images/32-view-ticket.png)

Now, click on the ticket subject.

You will see many pieces of information about the ticket. Scroll to
the bottom of the page.

Here you can **Reply** to the ticket:

![Display ticket](images/33-view-ticket2.png)

Go ahead and type in a reply and then click on **Update
Ticket** (bottom-right):

![Replying to ticket](images/34-reply-ticket.png)

**You should see this:**

![Reply sent](images/35-reply-ticket2.png)

The ticket is still open. Let's resolve it:

![View history](images/36-ticket-status-change.png)

Click on "Update Ticket" at the bottom of the screen to finish resolving the ticket.

![View history](images/36b-ticket-status-resolved.png)

The ticket is currently Resolved but you can reopen the ticket via
the RT web interface at any time, or if the original ticket creator
(**`sysadm`** in this case) replies to the resolution email RT sent, then
the ticket will be reopened.

View the history at the bottom of the page to see that the ticket is
currently resolved:

![View history](images/37-ticket-status-change2.png)

If you went back to your terminal session as the sysadm user and typed:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$ mutt
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

and responded to the email generated from Request Tracker, then your
ticket status will change. You can see this by reloading the RT web page
for the ticket and viewing the history at the bottom of the page:

**Using Mutt to Reply to an Email**

* After typing **`mutt`**, select the message you want to respond to using the
  arrow keys
* Press the **r** key for **r**eply.
* At the bottom of the page you will see, `To: System Admin via RT
  <net@db.campusY.ws.nsrc.org>` - Press ENTER to continue
* Next you'll see a suggested <<Subject:>> line. Press ENTER to choose
  what is shown.
* When you see, `Include message in reply? ([yes]/no):` press ENTER
  to include the message.
* Now you will be placed in an editor - possibly `nano`. Type in your
  response. We suggest to answer below the original message.
* Save and exit from the text editor (`:wq` in `vi`, `ctrl-x` and `<ENTER>` in `nano`).
* The next screen to appear looks complicated but simply press
  the `y` to send the message.
* That's it. You are done. You can press `q` twice to exit Mutt at this
  point if you wish.

If you go back to RT, select the Home you will see the ticket listed. Click on the 
ticket and scroll to the bottom of the history and you will see something like this:

![Ticket history showing reply](images/37-ticket-status-change3.png)

You now have a functioning RT instance with email integration!

You can experiment a bit. Now, this is not a very realistic setup,
since you are communication with yourself! But in fact, other users in
the classroom can send you email:

* Make sure they have configured their mail software (`sudo apt-get install postfix` 
  then accept the defaults and be sure to set /etc/mailname to the correct value.)
* Have the users send a mail to  you, for example:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~
echo "Where is my cat ?" | mail -s "Missing cat" net@db.campusY.ws.nsrc.org
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

* This should automatically create tickets in the **`net`** queue on your
  server "db.campusY" - verify that you do receive the tickets!

## Adding Watchers to a Queue

(Only one person should do this)

We are still missing an important feature: it's not practical to
have to log into RT to check if tickets have arrived. It would be much
more convenient if we received an email every time a problem request had
been submitted, no?

* To do these exercises you need to log out as the sysadm-serverX user and log back 
  in to Request Tracker as the root user.
  
![Logout as sysadm](images/37b-1-logout-as-sysadm.png)

* Now log back in as root:

![Log in as root](images/37b-2-login-as-root.png)

Now to receive an email every time a request is submitted we're going to modify the 
Queue settings for **`net`**:

* From the top menu, select **Admin** => **Queues** => **Select**

![Select queue](images/38-queue-modify-watchers.png)

From the **Queue** page, select the **`net`** queue by clicking on its
name, and you select the **Watchers** menu option at the top:

![Queue watchers](images/39-queue-modify1-watchers.png)

You should now see this:

![Modify queue watchers](images/40-queue-modify2-watchers.png)

Under **New watchers**, enter the group name **netmgmt** in the field:
<Find groups whose `[NAME]` `[matches]`>, as such:

![New watchers](images/41-queue-modify3-watchers.png)

And click on **Go!**

RT will search for all groups matching **netmgmt**. Of course there is
only one right now, which we created earlier. RT finds it and displays
the following:

![Matched groups](images/42-queue-modify4-watchers.png)

Notice how we select **`AdminCc`** from the pull down memu **Groups** next
to **netmgmt**. Do this and click on **Save Changes** at the bottom right.

The result should look like this:

![Watchers modified](images/43-queue-modify5-watchers.png)

What does it mean ? Well, ask another user to send a mail to net@db.campusY.ws.nsrc.org to create
a ticket, like before, but this time everyone who is a member of the net queue should 
receive a mail from RT with the ticket notification.

You can test this by issuing this command as the sysadm user on db.campusY.ws.nsrc.org:

~~~~~~~~~~
$ echo "Yet more problems with my router" | mail -s "More Router Problems' net@db.campusY.ws.nsrc.org
~~~~~~~~~~

Remember to change "Y" to your campus number.

Now log in to the other machines in your group and see if each sysadm user has received 
an email with this subject and text.

A bit later we will extend the use of RT by integrating it with other
Network Monitoring software using the rt-mailgate facility that we have
already configured in the `/etc/aliases` file.

## Exercise 12

(Anyone in the group can do this)

**Finding a ticket once it's closed.**

After a ticket has been resolved or closed may notice that it
disappears from your Queue. Actually finding a closed ticket requires a
few steps. 

You would need to close one of the tickets in your net queue before this search will 
provide you with any results. Right now you should have two open tickets. In your RT 
screen click on "Home" (upper-right of the screen) and you should see something like this:

![Current Open Tickets](images/43.5-search-current-open-tickets.png)

You should select one, or both, of these tickets and "resolve" them before continuing 
with this exercise (see previous exercises for resolving a ticket).

Now, click on **Tickets** => **New Search** on the top menu in RT:

![Search tickets](images/44-search.png)

and you will see a screen like this:

![Ticket search form](images/45-search2.png)

If you are going to search for items in a queue and there are already
items in the <<**Current search**>> box, then you should delete the items
from the <<**Current search**>> box first. Next in the <<**Add Criteria**>> box in
the <<**Queue**>>" choice select the <<**net**>> queue from the drop-down menu
(see below):

![Adding search terms](images/46-search3.png)

Click on <<**Add these terms**>> or <<**Add these terms and Search**>> - If you
just do <<**Add these terms**>> then go to the bottom of the page and click
on <<**Update format and Search**>> - RT will keep the search terms until you
delete them at a later time.

![Execute search](images/47-search4.png)

And the results of your search will look something like this and
you will be able to view tickets that have been closed, resolved, etc.
Clearly there will be more tickets in the results over time:

![Search results](images/48-search5.png)
