#!/usr/bin/php -q
<?php
// Esta línea es para que que haga no mantenga en un buffer el output
ob_implicit_flush(true); 
set_time_limit(6); 
error_reporting(0);  

// Se abren los diferentes archivos (STDIN, STDOUT y un archivo de log del AGI)
$in = fopen("php://stdin","r"); 
$out = fopen("php://stdout","w"); 
$stdlog = fopen("/var/log/asterisk/my_agi.log", "w"); 

// Si debug es true, escribe en el archivo de log definido anteriormente
$debug = true; 

// Toma el nombre del archivo con los números a dictar del primer parámetro
$archivo = $argv[1];

// Define la funcion read, que lee el input del STDIN
function read() { 
  global $in, $debug, $stdlog; 
  $input = str_replace("\n", "", fgets($in, 4096)); 
  if ($debug) fputs($stdlog, "read: $input\n"); 
  return $input; 
} 

// Define la funcion write, que escribe el output en el STDOUT
function write($line) { 
  global $debug, $stdlog, $out; 
  if ($debug) fputs($stdlog, "write: $line\n"); 
  fputs($out,$line."\n"); 
  fflush($out);
} 

// Parsea los headers del AGI (variables de entorno, etc) 
/*while ($env=read()) { 
  $s = split(": ",$env); 
  $agi[str_replace("agi_","",$s[0])] = trim($s[1]); 
  if (($env == "") || ($env == "\n")) { 
    break; 
  } 
} 
*/


// Lee el archivo que se paso como parametro
$lines = file($archivo);

// Reproduce los digitos contenidos en cada linea del mismo
// informando en el log del Asterisk la accion realizada
foreach ($lines as $line) {
    $line=trim($line);
    for ($i=0;$i<strlen($line);$i++) {
    	write("VERBOSE \"REPRODUCIENDO DIGITO $line[$i]\"");
    	read();
    	write("SAY DIGITS $line[$i] \"\"");
    	read();
        sleep(1);
    }
}

// Se cierran todos los handlers de archivos 
fclose($in); 
fclose($out); 
fclose($stdlog); 
exit; 

?>  
