<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001, 2002 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:  displays form for graphing
 */

  echo '<FORM ACTION="acid_graph_main.php" METHOD="post">';

  echo '<TABLE WIDTH="100%" BORDER=2 BGCOLOR="#CCCC99">
          <TR>
           <TD COLSPAN=2>';

  echo '<B>Chart Title:</B> &nbsp;
            <INPUT TYPE="text" NAME="user_chart_title" SIZE=60 VALUE="'.$user_chart_title.'"><BR>'; 
        
  echo '<B>Chart Type:</B>&nbsp;
        <SELECT NAME="chart_type">
         <OPTION VALUE=" "  '.chk_select($chart_type, " ").'>{ chart type }
         <OPTION VALUE="1" '.chk_select($chart_type, "1").'>Time (hour) vs. Number of Alerts
         <OPTION VALUE="2" '.chk_select($chart_type, "2").'>Time (day) vs. Number of Alerts
         <!--<OPTION VALUE="3" '.chk_select($chart_type, "3").'>Time (week) vs. Number of Alerts-->
         <OPTION VALUE="4" '.chk_select($chart_type, "4").'>Time (month) vs. Number of Alerts
         <!--<OPTION VALUE="5" '.chk_select($chart_type, "5").'>Time (year) vs. Number of Alerts-->
         <OPTION VALUE="6" '.chk_select($chart_type, "6").'>Src. IP address vs. Number of Alerts
         <OPTION VALUE="7" '.chk_select($chart_type, "7").'>Dst. IP address vs. Number of Alerts
         <OPTION VALUE="8" '.chk_select($chart_type, "8").'>Dst. UDP Port vs. Number of Alerts
         <OPTION VALUE="10" '.chk_select($chart_type, "10").'>Src. UDP Port vs. Number of Alerts
         <OPTION VALUE="9" '.chk_select($chart_type, "9").'>Dst. TCP Port vs. Number of Alerts
         <OPTION VALUE="11" '.chk_select($chart_type, "11").'>Src. TCP Port vs. Number of Alerts
         <OPTION VALUE="12" '.chk_select($chart_type, "12").'>Sig. Classification vs. Number of Alerts
         <OPTION VALUE="13" '.chk_select($chart_type, "13").'>Sensor vs. Number of Alerts
        </SELECT>';

  // Do you need other periods? Simply add them!
  echo '&nbsp;&nbsp;<b>Chart Period:</B>&nbsp;
        <SELECT NAME="chart_interval">
         <OPTION VALUE="0"  '.chk_select($chart_interval, "0").'>no period
         <OPTION VALUE="7" '.chk_select($chart_interval, "7").'>7 (a week)
         <OPTION VALUE="24" '.chk_select($chart_interval, "24").'>24 (whole day)
         <OPTION VALUE="168" '.chk_select($chart_interval, "168").'>168 (24x7)
        </SELECT><BR>';

  echo '&nbsp;&nbsp;<B>Size: (width x height)</B>
        &nbsp;<INPUT TYPE="text" NAME="width" SIZE=4 VALUE="'.$width.'">
        &nbsp;<B>x</B>
        &nbsp;<INPUT TYPE="text" NAME="height" SIZE=4 VALUE="'.$height.'">
        &nbsp;&nbsp;<BR>';

  echo '&nbsp;&nbsp;<B>Plot Margins: (left x right x top x bottom)</B>
        &nbsp;<INPUT TYPE="text" NAME="pmargin0" SIZE=4 VALUE="'.$pmargin0.'">
        &nbsp;<B>x</B>
        &nbsp;<INPUT TYPE="text" NAME="pmargin1" SIZE=4 VALUE="'.$pmargin1.'">
        &nbsp;<B>x</B>
        &nbsp;<INPUT TYPE="text" NAME="pmargin2" SIZE=4 VALUE="'.$pmargin2.'">
        &nbsp;<B>x</B>
        &nbsp;<INPUT TYPE="text" NAME="pmargin3" SIZE=4 VALUE="'.$pmargin3.'">
        &nbsp;&nbsp;<BR>';

  echo '&nbsp;&nbsp;<B>Plot type:</B> &nbsp;&nbsp;
            <INPUT TYPE="radio" NAME="chart_style" 
                   VALUE="bar" '.chk_check($chart_style, "bar").'> bar &nbsp;&nbsp
            <INPUT TYPE="radio" NAME="chart_style" 
                   VALUE="line" '.chk_check($chart_style, "line").'> line &nbsp;&nbsp
            <INPUT TYPE="radio" NAME="chart_style" 
                   VALUE="pie" '.chk_check($chart_style, "pie").'> pie ';

  echo '<br><b>Chart Begin:</B>&nbsp;
        <SELECT NAME="chart_begin_hour">
         <OPTION VALUE=" "  '.chk_select($chart_begin_hour, " ").'>{hour}'."\n";
        for ( $i = 0; $i <= 23; $i++ )
            echo "<OPTION VALUE=\"$i\" ".chk_select($chart_begin_hour, $i)." >$i\n";

  echo '</SELECT>
        <SELECT NAME="chart_begin_day">
         <OPTION VALUE=" "  '.chk_select($chart_begin_day, " ").'>{day}'."\n";
        for ( $i = 1; $i <= 31; $i++ )
            echo "<OPTION VALUE=\"$i\" ".chk_select($chart_begin_day, $i).">$i\n";

  echo '</SELECT>
        <SELECT NAME="chart_begin_month">
         <OPTION VALUE=" "  '.chk_select($chart_begin_month, " ").'>{month}
         <OPTION VALUE="01" '.chk_select($chart_begin_month, "01").'>January
         <OPTION VALUE="02" '.chk_select($chart_begin_month, "02").'>February
         <OPTION VALUE="03" '.chk_select($chart_begin_month, "03").'>March
         <OPTION VALUE="04" '.chk_select($chart_begin_month, "04").'>April
         <OPTION VALUE="05" '.chk_select($chart_begin_month, "05").'>May
         <OPTION VALUE="06" '.chk_select($chart_begin_month, "06").'>June
         <OPTION VALUE="07" '.chk_select($chart_begin_month, "07").'>July
         <OPTION VALUE="08" '.chk_select($chart_begin_month, "08").'>August
         <OPTION VALUE="09" '.chk_select($chart_begin_month, "09").'>September
         <OPTION VALUE="10" '.chk_select($chart_begin_month, "10").'>October
         <OPTION VALUE="11" '.chk_select($chart_begin_month, "11").'>November
         <OPTION VALUE="12" '.chk_select($chart_begin_month, "12").'>December
        </SELECT>
        <SELECT NAME="chart_begin_year">
        <OPTION VALUE=" " '.chk_select($chart_begin_year, " ").'>{year}
        <OPTION VALUE="1999" '.chk_select($chart_begin_year, "1999").'>1999
        <OPTION VALUE="2000" '.chk_select($chart_begin_year, "2000").'>2000
        <OPTION VALUE="2001" '.chk_select($chart_begin_year, "2001").'>2001
        <OPTION VALUE="2002" '.chk_select($chart_begin_year, "2002").'>2002
        <OPTION VALUE="2003" '.chk_select($chart_begin_year, "2003").'>2003
        <OPTION VALUE="2004" '.chk_select($chart_begin_year, "2004").'>2004
        </SELECT>';

  echo '<br><b>Chart End:</B>&nbsp;&nbsp;&nbsp;&nbsp;
        <SELECT NAME="chart_end_hour">
         <OPTION VALUE=" "  '.chk_select($chart_end_hour, " ").'>{hour}'."\n";
        for ( $i = 0; $i <= 23; $i++ )
           echo "<OPTION VALUE=$i ".chk_select($chart_end_hour, $i).">$i\n";

  echo '</SELECT>
        <SELECT NAME="chart_end_day">
         <OPTION VALUE=" "  '.chk_select($chart_end_day, " ").'>{day}'."\n";
        for ( $i = 1; $i <= 31; $i++ )
           echo "<OPTION VALUE=$i ".chk_select($chart_end_day, $i).">$i\n";

  echo '</SELECT>
        <SELECT NAME="chart_end_month">
         <OPTION VALUE=" "  '.chk_select($chart_end_month, " ").'>{month}
         <OPTION VALUE="01" '.chk_select($chart_end_month, "01").'>January
         <OPTION VALUE="02" '.chk_select($chart_end_month, "02").'>February
         <OPTION VALUE="03" '.chk_select($chart_end_month, "03").'>March
         <OPTION VALUE="04" '.chk_select($chart_end_month, "04").'>April
         <OPTION VALUE="05" '.chk_select($chart_end_month, "05").'>May
         <OPTION VALUE="06" '.chk_select($chart_end_month, "06").'>June
         <OPTION VALUE="07" '.chk_select($chart_end_month, "07").'>July
         <OPTION VALUE="08" '.chk_select($chart_end_month, "08").'>August
         <OPTION VALUE="09" '.chk_select($chart_end_month, "09").'>September
         <OPTION VALUE="10" '.chk_select($chart_end_month, "10").'>October
         <OPTION VALUE="11" '.chk_select($chart_end_month, "11").'>November
         <OPTION VALUE="12" '.chk_select($chart_end_month, "12").'>December
        </SELECT>
        <SELECT NAME="chart_end_year">
        <OPTION VALUE=" " '.chk_select($chart_end_year, " ").'>{year}
        <OPTION VALUE="1999" '.chk_select($chart_end_year, "1999").'>1999
        <OPTION VALUE="2000" '.chk_select($chart_end_year, "2000").'>2000
        <OPTION VALUE="2001" '.chk_select($chart_end_year, "2001").'>2001
        <OPTION VALUE="2002" '.chk_select($chart_end_year, "2002").'>2002
        <OPTION VALUE="2003" '.chk_select($chart_end_year, "2003").'>2003
        <OPTION VALUE="2004" '.chk_select($chart_end_year, "2004").'>2004
        </SELECT>';

  echo '<INPUT TYPE="submit" NAME="submit" VALUE="Graph Alerts"><BR>
        &nbsp;&nbsp; <BR>
        </TD></TR>';

  echo '<TR><TD>
        <TABLE WIDTH="100%" BORDER=1>
        <TR>
         <TD ALIGN="CENTER" WIDTH="50%"><B>X Axis</B></TD>
         <TD ALIGN="CENTER" WIDTH="50%"><B>Y Axis</B></TD>
        </TR>
        <TR>
         <TD>
           <B>Data Source:</B> &nbsp;
           <SELECT NAME="data_source">
           <OPTION VALUE=" " '.chk_select($data_source, " ").'>{ data source (AG) }';
           
           $temp_sql = "SELECT ag_id, ag_name FROM acid_ag";
           $tmp_result = $db->acidExecute($temp_sql);
           if ( ( $tmp_result ) )
           {
              while ( $myrow = $tmp_result->acidFetchRow() )
                echo '<OPTION VALUE="'.$myrow[0].'" '.chk_select($data_source, $myrow[0]).'>'.
                     '['.$myrow[0].'] '.$myrow[1];

              $tmp_result->acidFreeRows();
           }
 
           echo '</SELECT><BR>'.
                 /*<!--<B>Use Alerts of Type:</B>
                   <SELECT NAME="use_alerts">
                     <OPTION VALUE="0" '.chk_select($use_alerts, 0).'>alerts+portscans 
                     <OPTION VALUE="1" '.chk_select($use_alerts, 1).'>alerts only
                     <OPTION VALUE="2" '.chk_select($use_alerts, 2).'>portscans only
                     <OPTION VALUE="3" '.chk_select($use_alerts, 3).'>alert and portscans seperately
                   </SELECT><BR>-->*/
                 '<B>Minimum Threshold Value ( &gt;= ):</B> 
                 <INPUT TYPE="text" NAME="min_size" SIZE=5 VALUE='.$min_size.'>
                 &nbsp;&nbsp;
                 <BR>
                 <INPUT TYPE="checkbox" NAME="rotate_xaxis_lbl" VALUE="1" '.
                   chk_check($rotate_xaxis_lbl, "1").'>
                 &nbsp;
                 <B>Rotate Axis Labels (90 degrees)</B><BR>
                 <INPUT TYPE="checkbox" NAME="yaxis_grid" VALUE="1"  '.
                   chk_check($xaxis_grid, "1").'>
                  &nbsp;
                 <B>Show X-axis grid-lines</B><BR>
                 <B>Display X-axis label every
                 <INPUT TYPE="text" NAME="xaxis_label_inc" SIZE=4 VALUE='.$xaxis_label_inc.'>
                 &nbsp; data points
         </TD>
         <TD VALIGN="top">
           <INPUT TYPE="checkbox" NAME="yaxis_scale" VALUE="1" '.
             chk_check($yaxis_scale, "1").'>&nbsp;
           <B>Y-axis logarithmic</B><BR>
           <INPUT TYPE="checkbox" NAME="yaxis_grid" VALUE="1"  '.
             chk_check($yaxis_grid, "1").'>&nbsp;
           <B>Show Y-axis grid-lines</B>
         </TD>
        </TR>
        </TABLE></TD></TR>
     </TABLE>';

  echo '</FORM><P><HR>';

?>
