<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001, 2002 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 * Input GET/POST variables
 *   - caller: specifies the canned snapshot to run
 *   - submit:
 */

/*
 * $caller: an auxiliary variable used to determine the how the search parameters were entered (i.e.
 *          whether through a form or through another mechanism
 *  - "stat_alerts" : display results based on the the Alert Listings
 *  - "top_tcp" :
 *  - "top_udp" :
 *  - "top_icmp" :
 *  - "last_tcp" :
 *  - "last_udp" :
 *  - "last_icmp" :
 *
 * $submit: used to determine the next action which should be taken when the form is submitted.
 *  - "Query DB"       : triggers a query into the database
 *  - "ADD Time"       : adds another date/time row 
 *  - "ADD Addr"       : adds another IP address row
 *  - "ADD IP Field"   : adds another IP field row
 *  - "ADD TCP Port"   : adds another TCP port row
 *  - "ADD TCP Field"  : adds another TCP field row
 *  - "ADD UDP Port"   : adds another UDP port row
 *  - "ADD UDP Field"  : adds another UDP field row
 *  - "ADD ICMP Field" : adds another ICMP field row
 *  - "#X-(X-X)"       : sid-cid keys for a packet lookup
 *
 * $layer4: stores the layer 4 protocol used in query
 *
 * $save_sql: the current sql string generating the query
 *
 * $save_criteria: HTML-human readable criteria of the $save_sql string
 *
 * $num_result_rows: rows in the entire record set retried under the current 
 *                   query
 *
 * $current_view: current view of the result set
 *
 * $sort_order: how to sort the output
 *
 * ----- Search Result Variables ----
 * $action_chk_lst[]: array of check boxes to determine if an alert
 *                    was selected for action
 * $action_lst[]: array of (sid,cid) of all alerts on screen
 */
?>
<?php
  include("acid_constants.inc");
  include("acid_conf.php");
  include("acid_include.inc");

  include_once("acid_action.inc");
  include_once("acid_db_common.php");
  include_once("acid_common.php");
  include_once("acid_ag_common.php");
  include_once("acid_qry_common.php");

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_qry_main.php", "&new=1&submit=Query+DB");

  $new = ImportHTTPVar("new", VAR_DIGIT);
  $submit = ImportHTTPVar("submit");

/* Code to correct 'interesting' (read: unexplained) browser behavior */

/* Something with Netscape 4.75 such that the $submit variable is no recognized
 * under certain circumstances.  This one is a result of using HTTPS and 
 * clicking on TCP traffic profile from acid_main.php 
 */
if ( $cs->criteria['layer4']->Get() != "" && $submit == "" )
   $submit = "Query DB";

/* End 'interesting' browser code fixes */

  /* Totally new Search */
  if ( ($new == 1) && ($submit == "") ) 
  {
     $cs->InitState();
  }

  $cs->ReadState();

  $qs = new QueryState();
  $qs->AddCannedQuery("last_tcp", $last_num_alerts, "Last TCP", "time_d"); 
  $qs->AddCannedQuery("last_udp", $last_num_alerts, "Last UDP Alerts", "time_d");
  $qs->AddCannedQuery("last_icmp", $last_num_alerts, "Last ICMP Alerts", "time_d");
  $qs->AddCannedQuery("last_any", $last_num_alerts, "Last Alerts", "time_d");

  $page_title = "Query Results";
  if ( $qs->isCannedQuery() )
     PrintACIDSubHeader($page_title.": ".$qs->GetCurrentCannedQueryDesc(),
                        $page_title.": ".$qs->GetCurrentCannedQueryDesc(), $cs->GetBackLink());
  else
     PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());

  if ( in_array( $qs->GetCurrentCannedQuery(),
                 array ("last_tcp", "last_udp", "last_icmp", "last_any") ) )
       PrintFreshPage($refresh_stat_page, $stat_page_refresh_time);

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);

  $printing_ag = false;
?>

<FORM METHOD="POST" NAME="PacketForm" ACTION="acid_qry_main.php">

<?php
/* Dump some debugging information on the shared state */
if ( $debug_mode > 0 )
{
   PrintCriteriaState();
}

/* a browsing button was clicked -> increment view */
if ( is_numeric($submit) )
{
    if ( $debug_mode > 0 ) ErrorMessage("Browsing Clicked ($submit)");
    $qs->MoveView($submit);
    $submit = "Query DB";
}

/* Run the SQL Query and get results */
if ( $submit == "Query DB" ||
     $submit == "Selected" || $submit == "ALL on Screen" || $submit == "Entire Query" || 
     $qs->isCannedQuery() || 
     $qs->GetCurrentSort() != "" )
{
  /* Init and run the action */
  $criteria_clauses = ProcessCriteria();  

  $from = " FROM acid_event ".$criteria_clauses[0];
  $where = " WHERE ".$criteria_clauses[1];

  $qs->AddValidAction("ag_by_id");
  $qs->AddValidAction("ag_by_name");
  $qs->AddValidAction("add_new_ag");
  $qs->AddValidAction("del_alert");
  $qs->AddValidAction("email_alert");
  $qs->AddValidAction("email_alert2");
  $qs->AddValidAction("csv_alert");
  $qs->AddValidAction("archive_alert");
  $qs->AddValidAction("archive_alert2");

  $qs->AddValidActionOp("Selected");
  $qs->AddValidActionOp("ALL on Screen");
  $qs->AddValidActionOp("Entire Query");

  $qs->SetActionSQL("SELECT acid_event.sid, acid_event.cid $from $where");
  $et->Mark("Initialization");

  $qs->RunAction($submit, PAGE_QRY_ALERTS, $db);
  $et->Mark("Alert Action");

  if ( $debug_mode > 0 ) ErrorMessage("Initial/Canned Query or Sort Clicked");

  include("acid_qry_sqlcalls.php");
}
/* Return the input form to get more criteria from user */
else
{
   include("acid_qry_form.php");
}

//  $db->acidClose();

  $qs->SaveState();
  $et->Mark("Get Query Elements");
  $et->PrintTiming();

  echo "\n</FORM>\n";
  
  PrintACIDSubFooter();
?>





