<?php
/*
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Handles signatures and references in the 
 *          Snort signature language
 */

function GetSignatureName($sig_id, $db)
{
   $name = "";

   $temp_sql = "SELECT sig_name FROM signature WHERE sig_id='$sig_id'";
   $tmp_result = $db->acidExecute($temp_sql);
   if ( $tmp_result )
   {
      $myrow = $tmp_result->acidFetchRow();
      $name = $myrow[0];
      $tmp_result->acidFreeRows();
   }
   else
      $name = "[SigName unknown]";

   return $name;
}

function GetSignaturePriority($sig_id, $db)
{
   $priority = "";

   $temp_sql = "SELECT sig_priority FROM signature WHERE sig_id='$sig_id'";
   $tmp_result = $db->acidExecute($temp_sql);
   if ( $tmp_result )
   {
     $myrow = $tmp_result->acidFetchRow();
     $priority = $myrow[0];

     $tmp_result->acidFreeRows();
   }
   else
     $priority = "[SigPriority unknown]";

   return $priority;
}

function GetSignatureID($sig_id, $db)
{
   $id = "";
  
   if ( $sig_id == "" )
      return $id;

   $temp_sql = "SELECT sig_id FROM signature WHERE sig_name='$sig_id'";
   if ($db->DB_type == "mssql")
     $temp_sql = "SELECT sig_id FROM signature WHERE sig_name LIKE '".MssqlKludgeValue($sig_id)."' ";

   $tmp_result = $db->acidExecute($temp_sql);
   if ( $tmp_result )
   {
      $myrow = $tmp_result->acidFetchRow();
      $id = $myrow[0];
      $tmp_result->acidFreeRows();
   }

   return $id;
}

function GetRefSystemName($ref_system_id, $db)
{
   if ( $ref_system_id == "" )
      return "";

   $ref_system_name = "";

   $tmp_sql = "SELECT ref_system_name FROM reference_system WHERE ref_system_id='".$ref_system_id."'";
   $tmp_result = $db->acidExecute($tmp_sql);
   if ( $tmp_result )
   {
      $myrow = $tmp_result->acidFetchRow();
      $ref_system_name = $myrow[0];
      $tmp_result->acidFreeRows();
   }

   return $ref_system_name;
}

function GetSingleSignatureReference($ref_system, $ref_tag, $style)
{
   $tmp_ref_system_name = strtolower($ref_system);
   if ( in_array($tmp_ref_system_name, array_keys($GLOBALS['external_sig_link'])) )
   {
      if ( $style == 1 )
         return "<FONT SIZE=-1>[".
                "<A HREF=\"".$GLOBALS['external_sig_link'][$tmp_ref_system_name][0].
                             $ref_tag.
                             $GLOBALS['external_sig_link'][$tmp_ref_system_name][1]."\" ".
                             "TARGET=\"_ACID_ALERT_DESC\">".$ref_system."</A>".
                 "]</FONT>";
      else if ( $style == 2 )
         return "[".$ref_system."/$ref_tag] ";
   }            
   else
   {
      return $ref_system;
   }
}

function GetSignatureReference($sig_id, $db, $style)
{
   $ref = "";

   $temp_sql = "SELECT ref_seq, ref_id FROM sig_reference WHERE sig_id='".$sig_id."'";
   $tmp_sig_ref = $db->acidExecute($temp_sql);

   if ( $tmp_sig_ref )
   {
      $num_references = $tmp_sig_ref->acidRecordCount();
      for ( $i = 0; $i < $num_references; $i++)
      {
         $mysig_ref = $tmp_sig_ref->acidFetchRow();

         $temp_sql = "SELECT ref_system_id, ref_tag FROM reference WHERE ref_id='".$mysig_ref[1]."'";
         $tmp_ref_tag = $db->acidExecute($temp_sql);

         if ( $tmp_ref_tag )
         {
            $myrow = $tmp_ref_tag->acidFetchRow();
            $ref_tag = $myrow[1];
            $ref_system = GetRefSystemName($myrow[0], $db);
         }

         $ref = $ref.GetSingleSignatureReference($ref_system, $ref_tag, $style);

         /* Automatically add an ICAT reference is a CVE reference exists */
         if ( $ref_system == "cve" )
             $ref = $ref.GetSingleSignatureReference("icat", $ref_tag, $style);
       
         $tmp_ref_tag->acidFreeRows();
      }
      $tmp_sig_ref->acidFreeRows();
   }

   if ( $db->acidGetDBVersion() >= 103 )
   {
      $tmp_sql = "SELECT sig_sid FROM signature WHERE sig_id='".$sig_id."'";
      $tmp_sig_sid = $db->acidExecute($tmp_sql);

      if ( $tmp_sig_sid )
      {
         $myrow = $tmp_sig_sid->acidFetchRow();
         $sig_sid = $myrow[0];
      }
   }
   else
      $sig_sid = "";

   $href = "";

   /* snort.org should be documenting all official signatures,
    * so automatically add a link
    */
   if ( $sig_sid != "")
      $ref = $ref.GetSingleSignatureReference("snort", $sig_sid, $style);

   return $ref;
}

function BuildSigLookup($signature, $style)
/* - Paul Harrington <paul@pizza.org> : reference URL links
 * - Michael Bell <michael.bell@web.de> : links for IP address in spp_portscan alerts
 */
{
  if ($style == 2)
     return $signature;

  /* create hyperlinks for references */
  $pattern=array("/(IDS)(\d+)/", 
                 "/(IDS)(0+)(\d+)/",
                 "/BUGTRAQ ID (\d+)/",
                 "/MCAFEE ID (\d+)/",
                 "/(CVE-\d+-\d+)/");

  $replace=array("<A HREF=\"http://www.whitehats.com/\\1/\\2\" TARGET=\"_ACID_ALERT_DESC\">\\1\\2</A>",
                 "<A HREF=\"http://www.whitehats.com/\\1/\\3\" TARGET=\"_ACID_ALERT_DESC\">\\1\\2\\3</A>",
                 "<A HREF=\"".$GLOBALS['external_sig_link']['bugtraq'][0]."\\1\" TARGET=\"_ACID_ALERT_DESC\">BUGTRAQ ID \\1</A>",
                 "<A HREF=\"".$GLOBALS['external_sig_link']['mcafee'][0]."\\1\" TARGET=\"_ACID_ALERT_DESC\">MCAFEE ID \\1</A>",
                 "<A HREF=\"".$GLOBALS['external_sig_link']['cve'][0]."\\1\" TARGET=\"_ACID_ALERT_DESC\">\\1</A>");

  $msg = preg_replace($pattern, $replace, $signature);

  /* fixup portscan message strings */
  if ( stristr($msg, "spp_portscan") )
  {
      /* replace "spp_portscan: portscan status" => "spp_portscan"  */
      $msg = preg_replace("/spp_portscan: portscan status/", "spp_portscan", $msg);

      /* replace "spp_portscan: PORTSCAN DETECTED" => "spp_portscan detected" */
      $msg = preg_replace("/spp_portscan: PORTSCAN DETECTED/", "spp_portscan detected", $msg);

      /* create hyperlink for IP addresses in portscan alerts */
      $msg = preg_replace("/([0-9]*\.[0-9]*\.[0-9]*\.[0-9]*)/",
                          "<A HREF=\"acid_stat_ipaddr.php?ip=\\1&netmask=32\">\\1</A>",
                          $msg);
  }

  return $msg;
}

function BuildSigByID($sig_id, $db, $style = 1)
/*
 * sig_id: DB schema dependent
 *         - < v100: a text string of the signature
 *         - > v100: an ID (key) of a signature
 * db    : database handle
 * style : how should the signature be returned?
 *         - 1: (default) HTML
 *         - 2: text
 *
 * RETURNS: a formatted signature and the associated references
 */
{
  if ( $db->acidGetDBVersion() >= 100 )
  {
     /* Catch the odd circumstance where $sig_id is still an alert text string
      * despite using normalized signature as of DB version 100. 
      */
     if ( !is_numeric($sig_id) )
        return $sig_id;
     $sig_name = GetSignatureName($sig_id, $db);
     if ( $sig_name != "" )
        return GetSignatureReference($sig_id, $db, $style)." ".BuildSigLookup($sig_name, $style);
     else
     {
        if ( $style == 1 )
           return "($sig_id)<I>Unknown Sig Name</I>";
        else
           return "($sig_id) Unknown Sig Name";
     }
  }
  else
     return BuildSigLookup($sig_id, $style);
}

function GetSigClassID($sig_id, $db)
{
  $sql = "SELECT sig_class_id FROM signature ".
         "WHERE sig_id = '$sig_id'";

  $result = $db->acidExecute($sql);
  $row = $result->acidFetchRow();

  return $row[0]; 
}

function GetSigClassName ($class_id, $db)
{
  if ( $class_id == "" )
    return "<I>unclassified</I>";

  $sql = "SELECT sig_class_name FROM sig_class ". 
         "WHERE sig_class_id = '$class_id'";
  $result = $db->acidExecute($sql);

  $row = $result->acidFetchRow();
  if ( $row == "" )  
    return "<I>unclassified</I>";
  else
    return $row[0]; 
}

?>
