<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays statistics on the detected alerts   
 *
 * Input GET/POST variables
 *   - caller
 *   - submit:
 */
?>
<?php  
  include ("acid_constants.inc");
  include ("acid_conf.php");
  include ("acid_include.inc");
  include_once ("acid_db_common.php");
  include_once ("acid_qry_common.php");
  include_once ("acid_stat_common.php");

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_stat_alerts.php");
  $cs->ReadState();

  $qs = new QueryState();
  $qs->AddCannedQuery("most_frequent", $freq_num_alerts, "Most Frequent Alerts", "occur_d"); 
  $qs->AddCannedQuery("last_alerts", $last_num_ualerts, "Last Alerts", "last_d");

  $submit = ImportHTTPVar("submit");
  $qs->MoveView($submit);             /* increment the view if necessary */

  $page_title = "Alert Listing";
  if ( $qs->isCannedQuery() )
     PrintACIDSubHeader($page_title.": ".$qs->GetCurrentCannedQueryDesc(),
                        $page_title.": ".$qs->GetCurrentCannedQueryDesc(), $cs->GetBackLink());
  else
     PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());
  
  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);

  $criteria_clauses = ProcessCriteria();  
  PrintCriteria("");

  $from = " FROM acid_event ".$criteria_clauses[0];
  $where = " WHERE ".$criteria_clauses[1];

  $qs->AddValidAction("ag_by_id");
  $qs->AddValidAction("ag_by_name");
  $qs->AddValidAction("add_new_ag");
  $qs->AddValidAction("del_alert");
  $qs->AddValidAction("email_alert");
  $qs->AddValidAction("email_alert2");
  $qs->AddValidAction("csv_alert");
  $qs->AddValidAction("archive_alert");
  $qs->AddValidAction("archive_alert2");

  $qs->AddValidActionOp("Selected");
  $qs->AddValidActionOp("ALL on Screen");

  $qs->SetActionSQL($from.$where);
  $et->Mark("Initialization");

  $qs->RunAction($submit, PAGE_STAT_ALERTS, $db);
  $et->Mark("Alert Action");

  /* Get total number of events */
  $event_cnt = EventCnt($db);

  /* create SQL to get Unique Alerts */
  $cnt_sql = "SELECT count(DISTINCT signature) ".$from.$where;

  /* Run the query to determine the number of rows (No LIMIT)*/
  $qs->GetNumResultRows($cnt_sql, $db);
  $et->Mark("Counting Result size");

  /* Setup the Query Results Table */
  $qro = new QueryResultsOutput("acid_stat_alerts.php?caller=".$caller);

  $qro->AddTitle(" ");

  if ($db->DB_type != "mssql")
    $qro->AddTitle("Signature", 
                "sig_a", " ",
                         " ORDER BY sig_name ASC",
                "sig_d", " ",
                         " ORDER BY sig_name DESC");
  else
    $qro->AddTitle("Signature",
                "sig_a", " ",
                         " ORDER BY CONVERT(varchar(255), sig_name) ASC",
                "sig_d", " ",
                         " ORDER BY CONVERT(varchar(255), sig_name) DESC");

  if ( $db->acidGetDBVersion() >= 103 )
    $qro->AddTitle("Classification",
                   "class_a", ", MIN(sig_class_id) ",
                              " ORDER BY sig_class_id ASC ",
                   "class_d", ", MIN(sig_class_id) ",
                              " ORDER BY sig_class_id DESC "); 

  $qro->AddTitle("Total<BR>#", 
                "occur_a", " ",
                           " ORDER BY sig_cnt ASC",
                "occur_d", " ",
                           " ORDER BY sig_cnt DESC");
  $qro->AddTitle("Sensor<BR>#");
  $qro->AddTitle("Src.<BR>Addr.", 
                "saddr_a", ", count(ip_src) AS saddr_cnt ",
                           " ORDER BY saddr_cnt ASC",
                "saddr_d", ", count(ip_src) AS saddr_cnt ",
                           " ORDER BY saddr_cnt DESC");
  $qro->AddTitle("Dest.<BR>Addr.", 
                "daddr_a", ", count(ip_dst) AS daddr_cnt ",
                           " ORDER BY daddr_cnt ASC",
                "daddr_d", ", count(ip_dst) AS daddr_cnt ",
                           " ORDER BY daddr_cnt DESC");
  $qro->AddTitle("First", 
                "first_a", ", min(timestamp) AS first_timestamp ",
                           " ORDER BY first_timestamp ASC",
                "first_d", ", min(timestamp) AS first_timestamp ",
                           " ORDER BY first_timestamp DESC");

  if ( $show_previous_alert == 1 )
     $qro->AddTitle("Previous");

  $qro->AddTitle("Last", 
                "last_a", ", max(timestamp) AS last_timestamp ",
                           " ORDER BY last_timestamp ASC",
                "last_d", ", max(timestamp) AS last_timestamp ",
                           " ORDER BY last_timestamp DESC");

  $sort_sql = $qro->GetSortSQL($qs->GetCurrentSort(), $qs->GetCurrentCannedQuerySort());
  //if ( $sort_sql == NULL )
  //   ErrorMessage("Invalid or No Sort type was specified");

  $sql = "SELECT DISTINCT signature, count(signature) as sig_cnt, ".
         "min(timestamp), max(timestamp) ".
         $sort_sql[0].$from.$where." GROUP BY signature ".$sort_sql[1];

  /* Run the Query again for the actual data (with the LIMIT) */
  $result = $qs->ExecuteOutputQuery($sql, $db);
  $et->Mark("Retrieve Query Data");

  if ( $debug_mode == 1 )
  {
     $qs->PrintCannedQueryList();
     $qs->DumpState();
     echo "$sql<BR>";
  }

  /* Print the current view number and # of rows */
  $qs->PrintResultCnt();

  echo '<FORM METHOD="post" NAME="PacketForm" ACTION="acid_stat_alerts.php">';
  
  $qro->PrintHeader();

  $i = 0;
  while ( ($myrow = $result->acidFetchRow()) && ($i < $qs->GetDisplayRowCnt()) )
  {
     $sig_name = $myrow[0];

     /* get Total Occurrence */
     $total_occurances = $myrow[1];

     /* Unique sensor, source and destination IPs with this signature */
     $temp = "SELECT COUNT(DISTINCT acid_event.sid), ".
             "COUNT(DISTINCT ip_src), COUNT(DISTINCT ip_dst) ".
              $from.$where." AND signature='".$sig_name."'";

     $result2 = $db->acidExecute($temp);
     $statrow = $result2->acidFetchRow();
     $num_sensors = $statrow[0];
     $num_src_ip = $statrow[1];
     $num_dst_ip = $statrow[2];
     $result2->acidFreeRows(); 

     /* First and Last timestamp of this signature */
     $start_time = $myrow[2];
     $stop_time = $myrow[3];

     $temp = "SELECT timestamp, acid_event.sid, acid_event.cid ".$from.$where.
             " AND signature='".$sig_name."'
             ORDER BY timestamp DESC";
     $result2 = $db->acidExecute($temp, 0, 2);
     $last = $result2->acidFetchRow();
     $last_num = $total_occurances - 1;

     /* Getting the previous timestamp of this signature 
      * (I.E. The occurances before Last Timestamp) 
      */
     if ( $show_previous_alert == 1 )
     {
        if ( $total_occurances == 1 )
        {
           $prev = $last;
           $prev_time = $prev[0];
           $prev_num = 0;
        }
        else
        {
                $prev = $result2->acidFetchRow();
                $prev_time = $prev[0];
		$prev_num = $total_occurances - 2;
                $result2->acidFreeRows();
        }
     }

     /* Doing the same as above for the first entry that we are searching for.
      * The reason for doing this is because some older DB's such as ones using ODBC
      * probably don't support the move() function. Therefore, for the older DB's 
      * to get the first entry from the $temp variable above, we would need to 
      * continue to call MoveNext() for each and every entry for that signature. For 
      * signatures with a large amount of alerts(i.e. >1000), this could cause a severe
      * performance hit for those users.
      */ 
     $temp = "SELECT timestamp, acid_event.sid, acid_event.cid ".$from.$where.
             " AND signature='".$sig_name."'
             ORDER BY timestamp ASC";
     $result2 = $db->acidExecute($temp, 0, 1);
     $first = $result2->acidFetchRow();
     $first_num = 0;
     $result2->acidFreeRows();

     /* Print out */ 
     qroPrintEntryHeader($i);

     $tmp_rowid = rawurlencode($sig_name);
     echo '  <TD>&nbsp;&nbsp;
                 <INPUT TYPE="checkbox" NAME="action_chk_lst['.$i.']" VALUE="'.$tmp_rowid.'">
                 &nbsp;&nbsp;
             </TD>';
     echo '      <INPUT TYPE="hidden" NAME="action_lst['.$i.']" VALUE="'.$tmp_rowid.'">';

     qroPrintEntry(BuildSigByID($sig_name, $db));

     if ( $db->acidGetDBVersion() >= 103 )
        qroPrintEntry(GetSigClassName(GetSigClassID($sig_name, $db), $db));

     qroPrintEntry('<FONT>'.
                   '<A HREF="acid_qry_main.php?new=1&sig%5B0%5D=%3D&sig%5B1%5D='.
                   (rawurlencode($sig_name)).'&sig_type=1'.
                   '&submit=Query+DB&num_result_rows=-1">'.$total_occurances.'</A> 
                   ('.(round($total_occurances/$event_cnt*100)).'%)'.
                   '</FONT>');

     qroPrintEntry('<A HREF="acid_stat_sensor.php?sig%5B0%5D=%3D&sig%5B1%5D='.
                    rawurlencode($sig_name).'&sig_type=1">'.$num_sensors.'</A>');

     if ( $db->acidGetDBVersion() >= 100 )
        $addr_link = '&sig_type=1&sig%5B0%5D=%3D&sig%5B1%5D='.rawurlencode($sig_name);
     else
        $addr_link = '&sig%5B0%5D=%3D&sig%5B1%5D='.rawurlencode($sig_name);

     qroPrintEntry('<FONT>'.BuildUniqueAddressLink(1, $addr_link).$num_src_ip.'</A></FONT>');
     qroPrintEntry('<FONT>'.BuildUniqueAddressLink(2, $addr_link).$num_dst_ip.'</A></FONT>');
     qroPrintEntry('<FONT>'.
	           '<A HREF="acid_qry_alert.php?'.
                   'submit=%23'.$first_num.'-%28'.$first[1].'-'.$first[2].'%29">'.
	           $start_time.'</FONT>');

     if ( $show_previous_alert == 1 )
        qroPrintEntry('<FONT>'.
                      '<A HREF="acid_qry_alert.php?'.
                      'submit=%23'.$prev_num.'-%28'.$prev[1].'-'.$prev[2].'%29">'.
		      $prev_time.'</FONT>');
     qroPrintEntry('<FONT>'.
                   '<A HREF="acid_qry_alert.php?'.
                   'submit=%23'.$last_num.'-%28'.$last[1].'-'.$last[2].'%29">'.
                   $stop_time.'</FONT>');

     qroPrintEntryFooter();

     $i++;
     $prev_time = null;
  }

  $result->acidFreeRows();

  $qro->PrintFooter();

  $qs->PrintBrowseButtons();
  $qs->PrintAlertActionButtons();
  $qs->SaveState();
  $et->Mark("Get Query Elements");
  $et->PrintTiming();

  echo "\n</FORM>\n";
  
  PrintACIDSubFooter();
?>
