<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays statistics on the detected alerts   
 *
 * Input GET/POST variables
 *   - caller
 *   - submit:
 */
?>
<?php  
  include ("acid_constants.inc");
  include ("acid_conf.php");
  include ("acid_include.inc");
  include_once ("acid_db_common.php");
  include_once ("acid_qry_common.php");
  include_once ("acid_stat_common.php");

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_stat_class.php");
  $cs->ReadState();

  $qs = new QueryState();

  $submit = ImportHTTPVar("submit");
  $qs->MoveView($submit);             /* increment the view if necessary */

  $page_title = "Classification";
  if ( $qs->isCannedQuery() )
     PrintACIDSubHeader($page_title.": ".$qs->GetCurrentCannedQueryDesc(),
                        $page_title.": ".$qs->GetCurrentCannedQueryDesc(), $cs->GetBackLink());
  else
     PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());
  
  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);

  $criteria_clauses = ProcessCriteria();  
  PrintCriteria("");

  $from = " FROM acid_event ".$criteria_clauses[0];
  $where = " WHERE ".$criteria_clauses[1];

  $qs->AddValidAction("ag_by_id");
  $qs->AddValidAction("ag_by_name");
  $qs->AddValidAction("add_new_ag");
  $qs->AddValidAction("del_alert");
  $qs->AddValidAction("email_alert");
  $qs->AddValidAction("email_alert2");
  $qs->AddValidAction("csv_alert");
  $qs->AddValidAction("archive_alert");
  $qs->AddValidAction("archive_alert2");

  $qs->AddValidActionOp("Selected");
  $qs->AddValidActionOp("ALL on Screen");

  $qs->SetActionSQL($from.$where);
  $et->Mark("Initialization");

  $qs->RunAction($submit, 50, $db);
  $et->Mark("Alert Action");

  /* Get total number of events */
  $event_cnt = EventCnt($db);

  /* create SQL to get Unique Alerts */
  $cnt_sql = "SELECT count(DISTINCT sig_class_id) ".$from.$where;

  /* Run the query to determine the number of rows (No LIMIT)*/
  $qs->GetNumResultRows($cnt_sql, $db);
  $et->Mark("Counting Result size");

  /* Setup the Query Results Table */
  $qro = new QueryResultsOutput("acid_stat_class.php?caller=".$caller);

  $qro->AddTitle(" ");
  $qro->AddTitle("Classification", 
                "class_a", " ",
                         " ORDER BY sig_class_id ASC",
                "class_d", " ",
                         " ORDER BY sig_class_id DESC");

  $qro->AddTitle("Total<BR>#", 
                "occur_a", " ",
                           " ORDER BY num_events ASC",
                "occur_d", " ",
                           " ORDER BY num_events DESC");
  $qro->AddTitle("Sensor<BR>#",
                 "sensor_a", " ",
                             " ORDER BY num_sensors ASC",
                 "sensor_d", " ",
                             " ORDER BY num_sensors DESC");
  $qro->AddTitle("Signatures",
                 "sig_a", " ",
                          " ORDER BY num_sig ASC",
                 "sig_d", " ",
                          " ORDER BY num_sig DESC");
  $qro->AddTitle("Src.<BR>Addr.", 
                "saddr_a", ", count(ip_src) AS saddr_cnt ",
                           " ORDER BY saddr_cnt ASC",
                "saddr_d", ", count(ip_src) AS saddr_cnt ",
                           " ORDER BY saddr_cnt DESC");
  $qro->AddTitle("Dest.<BR>Addr.", 
                "daddr_a", ", count(ip_dst) AS daddr_cnt ",
                           " ORDER BY daddr_cnt ASC",
                "daddr_d", ", count(ip_dst) AS daddr_cnt ",
                           " ORDER BY daddr_cnt DESC");
  $qro->AddTitle("First", 
                "first_a", ", min(timestamp) AS first_timestamp ",
                           " ORDER BY first_timestamp ASC",
                "first_d", ", min(timestamp) AS first_timestamp ",
                           " ORDER BY first_timestamp DESC");

  $qro->AddTitle("Last", 
                "last_a", ", max(timestamp) AS last_timestamp ",
                           " ORDER BY last_timestamp ASC",
                "last_d", ", max(timestamp) AS last_timestamp ",
                           " ORDER BY last_timestamp DESC");

  $sort_sql = $qro->GetSortSQL($qs->GetCurrentSort(), $qs->GetCurrentCannedQuerySort());
  //if ( $sort_sql == NULL )
  //   ErrorMessage("Invalid or No Sort type was specified");

  $sql = "SELECT DISTINCT sig_class_id, ".
         " COUNT(acid_event.cid) as num_events,".
         " COUNT( DISTINCT acid_event.sid) as num_sensors, ".
         " COUNT( DISTINCT signature ) as num_sig, ".
         " COUNT( DISTINCT ip_src ) as num_sip, ".
         " COUNT( DISTINCT ip_dst ) as num_dip, ".
         " min(timestamp) as first_timestamp, ".
         " max(timestamp) as last_timestamp ".
         $sort_sql[0].$from.$where." GROUP BY sig_class_id ".$sort_sql[1];

  /* Run the Query again for the actual data (with the LIMIT) */
  $result = $qs->ExecuteOutputQuery($sql, $db);
  $et->Mark("Retrieve Query Data");

  if ( $debug_mode == 1 )
  {
     $qs->PrintCannedQueryList();
     $qs->DumpState();
     echo "$sql<BR>";
  }

  /* Print the current view number and # of rows */
  $qs->PrintResultCnt();

  echo '<FORM METHOD="post" NAME="PacketForm" ACTION="acid_stat_class.php">';
  
  $qro->PrintHeader();

  $i = 0;
  while ( ($myrow = $result->acidFetchRow()) && ($i < $qs->GetDisplayRowCnt()) )
  {
     $class_id = $myrow[0];
     if ( $class_id == "" )
        $class_id = 0;
     $total_occurances = $myrow[1];
     $sensor_num = $myrow[2];
     $sig_num = $myrow[3];
     $sip_num = $myrow[4];
     $dip_num = $myrow[5];
     $min_time = $myrow[6];
     $max_time = $myrow[7];

     /* Print out */ 
     qroPrintEntryHeader($i);

     $tmp_rowid = rawurlencode($class_id);
     echo '  <TD>&nbsp;&nbsp;
                 <INPUT TYPE="checkbox" NAME="action_chk_lst['.$i.']" VALUE="'.$tmp_rowid.'">
                 &nbsp;&nbsp;
             </TD>';
     echo '      <INPUT TYPE="hidden" NAME="action_lst['.$i.']" VALUE="'.$tmp_rowid.'">';

     qroPrintEntry(GetSigClassName($class_id, $db));

     qroPrintEntry('<FONT>'.
                   '<A HREF="acid_qry_main.php?new=1&sig_class='.$class_id.
                   '&submit=Query+DB&num_result_rows=-1">'.$total_occurances.'</A> 
                   ('.(round($total_occurances/$event_cnt*100)).'%)'.
                   '</FONT>');
     qroPrintEntry('<FONT><A HREF="acid_stat_sensor.php?sig_class='.$class_id.'">'.
                    $sensor_num.'</A>');
     qroPrintEntry('<FONT><A HREF="acid_stat_alerts.php?sig_class='.$class_id.'">'.
                    $sig_num.'</FONT>');

     qroPrintEntry('<FONT>'.BuildUniqueAddressLink(1, '&sig_class='.$class_id).$sip_num.'</A></FONT>');
     qroPrintEntry('<FONT>'.BuildUniqueAddressLink(2, '&sig_class='.$class_id).$dip_num.'</A></FONT>');

     qroPrintEntry('<FONT>'.$min_time.'</FONT>');
     qroPrintEntry('<FONT>'.$max_time.'</FONT>');

     qroPrintEntryFooter();

     $i++;
     $prev_time = null;
  }

  $result->acidFreeRows();

  $qro->PrintFooter();

  $qs->PrintBrowseButtons();
  $qs->PrintAlertActionButtons();
  $qs->SaveState();
  $et->Mark("Get Query Elements");
  $et->PrintTiming();

  echo "\n</FORM>\n";
  
  PrintACIDSubFooter();
?>
