/*********************************************************************
anomsensor.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

anomsensor.h contains the types and some macro function declarations that
are used in the tree in Spade

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#ifndef ANOMSENSOR_H
#define ANOMSENSOR_H

#include <stdio.h>
#include <limits.h>
#include "params.h"

/* this needs to be set to a type capable of storing a 32 bit unsigned int */
typedef unsigned int u32;
#define MAX_U32 UINT_MAX
/* this needs to be set to a type capable of storing a 16 bit unsigned int */
typedef unsigned short u16;
#define MAX_U16 USHRT_MAX


typedef enum _features { SIP, DIP, SPORT, DPORT } features;
#define NUM_FEATURES 4
/*typedef enum _features { SIP, DIP, SPORT, DPORT, TTL, WIN } features;
#define NUM_FEATURES 6*/
extern const char *featurename[NUM_FEATURES];

typedef struct _featcomb {
	struct _featcomb *next[NUM_FEATURES];
	double val[NUM_FEATURES];
} *featcomb;

/* index type into memory block data structures */
typedef u32 mindex;

/* mindex used with top bit indicating if one of two datatypes is present */
typedef u32 dmindex;

/* the type of the values of the features */
typedef u32 valtype;

typedef struct _treeroot {
	mindex next;
	dmindex root; /* root node, if top bit is 1, it is a leafnode */
	features type;
} treeroot;

typedef struct _intnode {
	double sum;
	valtype sortpt;
	dmindex left;  /* left and right node, if top bit is 1,
	                  it is a leafnode */
	dmindex right;
	u16 wait; /* the number of additions to the subtree to wait
	             till checking for reblancing */
} intnode;

typedef struct _leafnode {
	double count;
	valtype value;
	mindex nexttree; 
} leafnode;


#define bits2blocksize(b) (1 << b)

#define ROOT_BLOCK_SIZE bits2blocksize(ROOT_BLOCK_BITS)
#define ROOT_BLOCK_MASK ((1 << ROOT_BLOCK_BITS) -1)
#define tree(i) ROOT_M[i>>ROOT_BLOCK_BITS][i&ROOT_BLOCK_MASK]
#define root_index(p,i) ((p<<ROOT_BLOCK_BITS)+i)

#define INT_BLOCK_SIZE bits2blocksize(INT_BLOCK_BITS)
#define INT_BLOCK_MASK ((1 << INT_BLOCK_BITS) -1)
#define intnode(i) INT_M[i>>INT_BLOCK_BITS][i&INT_BLOCK_MASK]
#define intnode_index(p,i) ((p<<INT_BLOCK_BITS)+i)

#define LEAF_BLOCK_SIZE bits2blocksize(LEAF_BLOCK_BITS)
#define LEAF_BLOCK_MASK ((1 << LEAF_BLOCK_BITS) -1)
#define leafnode(i) LEAF_M[i>>LEAF_BLOCK_BITS][i&LEAF_BLOCK_MASK]
#define leafnode_index(p,i) ((p<<LEAF_BLOCK_BITS)+i)

#define rfreenext(n) (n).next
#define ifreenext(n) (n).left
#define lfreenext(n) (n).nexttree

/* something of valtype that cannot be a sortpt */
#define NOT_A_SORTPT MAX_U32

extern mindex TNULL;
extern dmindex DMINDEXMASK;

extern treeroot **ROOT_M;
extern intnode **INT_M;
extern leafnode **LEAF_M;
extern mindex root_freelist;
extern mindex int_freelist;
extern mindex leaf_freelist;

#endif
