package Bundle::Private::KeystoreSignerPre;

use strict;
use vars qw(
  $VERSION
);

$VERSION = do { my @r = ( q$Revision: 1.4 $ =~ /\d+/g ); sprintf "%d." . "%03d" x $#r, @r; };



__END__

=head1 NAME

Bundle::Private::KeystoreSignerPre - A bundle to install all prerequisits needed to install Net::DNS::SEC::Maint::Key and Net::DNS::SEC::Maint::Zone

=head1 SYNOPSIS

C<perl -MCPAN -e 'install  Bundle::Private::KeystoreSignerPre'>

=head1 CONTENTS

Digest::SHA1

Digest::HMAC_MD5

Net::DNS

Crypt::OpenSSL::Random

Crypt::OpenSSL::RSA

Digest::BubbleBabble

Crypt::OpenSSL::Bignum

Crypt::OpenSSL::DSA

Net::DNS::SEC

Net::DNS::Zone::Parser 

IO::Handle 

File::Basename 

Getopt::Std    

URI

IO::Stringy

Mail::Field

Mail::Header

Mail::Internet

HTML::Tagset

HTML::Parser

LWP::UserAgent
    
XML::Parser

SOAP::Transport::HTTP 

SOAP::Lite

Term::ReadLine

Term::ReadLine::Gnu

IO::File

File::Temp

File::Path

File::Copy

File::Basename

IO::LockedFile

Data::Dumper

Log::Log4perl


=head1 DESCRIPTION

This is a Bundle to install the prerequisites needed to install the
Net::DNS::SEC::Maint::Zone and Net::DNS::SEC::Maint::Key packages.
These two packages can be used to build a keystore/signer application
server.

We have tried to bundle all dependencies on the packages needed by
Net::DNS::SEC::Maint::Zone and Net::DNS::SEC::Maint::Key as well so the
list of modules is long and somewhat esotheric.

=head1 AUTHOR

Olaf Kolkman<lt>F<net-dns@ripe.net>E<gt>
(Author only of this bundle, not of the modules it lists)

=cut
